/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.compare;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.compare.AbstractComparator;
import com.helger.commons.compare.CollatorUtils;
import com.helger.commons.compare.CompareUtils;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.string.ToStringGenerator;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractCollationComparator<DATATYPE>
extends AbstractComparator<DATATYPE> {
    private final Collator m_aCollator;

    public AbstractCollationComparator() {
        this((Locale)null, ESortOrder.DEFAULT, (Comparator)null);
    }

    public AbstractCollationComparator(@Nullable Comparator<? super DATATYPE> comparator) {
        this((Locale)null, ESortOrder.DEFAULT, comparator);
    }

    public AbstractCollationComparator(@Nonnull ESortOrder eSortOrder) {
        this((Locale)null, eSortOrder, (Comparator)null);
    }

    public AbstractCollationComparator(@Nonnull ESortOrder eSortOrder, @Nullable Comparator<? super DATATYPE> comparator) {
        this((Locale)null, eSortOrder, comparator);
    }

    public AbstractCollationComparator(@Nullable Locale locale) {
        this(locale, ESortOrder.DEFAULT, (Comparator)null);
    }

    public AbstractCollationComparator(@Nullable Locale locale, @Nullable Comparator<? super DATATYPE> comparator) {
        this(locale, ESortOrder.DEFAULT, comparator);
    }

    public AbstractCollationComparator(@Nullable Locale locale, @Nonnull ESortOrder eSortOrder) {
        this(locale, eSortOrder, (Comparator)null);
    }

    public AbstractCollationComparator(@Nullable Locale locale, @Nonnull ESortOrder eSortOrder, @Nullable Comparator<? super DATATYPE> comparator) {
        super(eSortOrder, comparator);
        this.m_aCollator = CollatorUtils.getCollatorSpaceBeforeDot(locale);
    }

    public AbstractCollationComparator(@Nonnull Collator collator) {
        this(collator, ESortOrder.DEFAULT, (Comparator)null);
    }

    public AbstractCollationComparator(@Nonnull Collator collator, @Nullable Comparator<? super DATATYPE> comparator) {
        this(collator, ESortOrder.DEFAULT, comparator);
    }

    public AbstractCollationComparator(@Nonnull Collator collator, @Nonnull ESortOrder eSortOrder) {
        this(collator, eSortOrder, (Comparator)null);
    }

    public AbstractCollationComparator(@Nonnull Collator collator, @Nonnull ESortOrder eSortOrder, @Nullable Comparator<? super DATATYPE> comparator) {
        super(eSortOrder, comparator);
        ValueEnforcer.notNull(collator, "Collator");
        this.m_aCollator = (Collator)collator.clone();
    }

    @Nullable
    protected abstract String asString(@Nonnull DATATYPE var1);

    @Nullable
    private String _nullSafeGetAsString(@Nullable DATATYPE DATATYPE) {
        return DATATYPE == null ? null : this.asString(DATATYPE);
    }

    @Override
    protected final int mainCompare(@Nullable DATATYPE DATATYPE, @Nullable DATATYPE DATATYPE2) {
        String string = this._nullSafeGetAsString(DATATYPE);
        String string2 = this._nullSafeGetAsString(DATATYPE2);
        return CompareUtils.nullSafeCompare(string, string2, this.m_aCollator);
    }

    public String toString() {
        return new ToStringGenerator(this).append("sortOrder", this.getSortOrder()).append("collator", this.m_aCollator).toString();
    }
}

