/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.filter;

import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.filter.IFilter;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FilterChainOR<DATATYPE>
implements IFilter<DATATYPE> {
    private final List<? extends IFilter<? super DATATYPE>> m_aFilters;

    public FilterChainOR(IFilter<? super DATATYPE> ... iFilterArray) {
        this.m_aFilters = ContainerHelper.newList(iFilterArray);
    }

    public FilterChainOR(@Nullable Iterable<? extends IFilter<? super DATATYPE>> iterable) {
        this.m_aFilters = ContainerHelper.newList(iterable);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<? extends IFilter<? super DATATYPE>> getContainedFilters() {
        return ContainerHelper.newList(this.m_aFilters);
    }

    @Override
    public boolean matchesFilter(@Nullable DATATYPE DATATYPE) {
        for (IFilter<DATATYPE> iFilter : this.m_aFilters) {
            if (!iFilter.matchesFilter(DATATYPE)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FilterChainOR)) {
            return false;
        }
        FilterChainOR filterChainOR = (FilterChainOR)object;
        return this.m_aFilters.equals(filterChainOR.m_aFilters);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aFilters)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("filters", this.m_aFilters).toString();
    }

    @Nonnull
    public static <DATATYPE> FilterChainOR<DATATYPE> create(IFilter<? super DATATYPE> ... iFilterArray) {
        return new FilterChainOR<DATATYPE>(iFilterArray);
    }

    @Nonnull
    public static <DATATYPE> FilterChainOR<DATATYPE> create(@Nullable Iterable<? extends IFilter<? super DATATYPE>> iterable) {
        return new FilterChainOR<DATATYPE>(iterable);
    }
}

