/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.format.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.format.IFormatter;
import com.helger.commons.format.impl.AbstractStringFormatter;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public final class MinLengthAddTrailingFormatter
extends AbstractStringFormatter {
    private final int m_nMinLength;
    private final char m_cFill;

    public MinLengthAddTrailingFormatter(@Nonnegative int n, char c) {
        this(null, n, c);
    }

    public MinLengthAddTrailingFormatter(@Nullable IFormatter iFormatter, @Nonnegative int n, char c) {
        super(iFormatter);
        ValueEnforcer.isGT0(n, "MinLength");
        this.m_nMinLength = n;
        this.m_cFill = c;
    }

    @Override
    protected String getFormattedValueAsString(@Nullable Object object) {
        String string = this.getValueAsString(object);
        if (string.length() >= this.m_nMinLength) {
            return string;
        }
        return string + StringHelper.getRepeated(this.m_cFill, this.m_nMinLength - string.length());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MinLengthAddTrailingFormatter)) {
            return false;
        }
        MinLengthAddTrailingFormatter minLengthAddTrailingFormatter = (MinLengthAddTrailingFormatter)object;
        return this.m_nMinLength == minLengthAddTrailingFormatter.m_nMinLength && this.m_cFill == minLengthAddTrailingFormatter.m_cFill;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nMinLength).append(this.m_cFill).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("minLength", this.m_nMinLength).append("fill", this.m_cFill).toString();
    }
}

