/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.filter.FilterChainAND;
import com.helger.commons.filter.FilterChainOR;
import com.helger.commons.filter.IFilter;
import com.helger.commons.io.file.filter.FileFilterFromFilenameFilter;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FileFilterToIFilterAdapter
implements IFilter<File> {
    private final FileFilter m_aFileFilter;

    public FileFilterToIFilterAdapter(@Nonnull FilenameFilter filenameFilter) {
        this(new FileFilterFromFilenameFilter(filenameFilter));
    }

    public FileFilterToIFilterAdapter(@Nonnull FileFilter fileFilter) {
        this.m_aFileFilter = ValueEnforcer.notNull(fileFilter, "FileFilter");
    }

    @Nonnull
    public FileFilter getFileFilter() {
        return this.m_aFileFilter;
    }

    @Override
    public boolean matchesFilter(@Nullable File file) {
        return file != null && this.m_aFileFilter.accept(file);
    }

    public String toString() {
        return new ToStringGenerator(this).append("fileFilter", this.m_aFileFilter).toString();
    }

    @Nullable
    public static IFilter<File> create(@Nullable FileFilter fileFilter) {
        return fileFilter == null ? null : new FileFilterToIFilterAdapter(fileFilter);
    }

    @Nullable
    public static IFilter<File> create(@Nullable FilenameFilter filenameFilter) {
        return filenameFilter == null ? null : new FileFilterToIFilterAdapter(filenameFilter);
    }

    @Nonnull
    public static IFilter<File> getANDChained(FileFilter ... fileFilterArray) {
        ValueEnforcer.notEmpty(fileFilterArray, "FileFilters");
        ArrayList<FileFilterToIFilterAdapter> arrayList = new ArrayList<FileFilterToIFilterAdapter>();
        for (FileFilter fileFilter : fileFilterArray) {
            arrayList.add(new FileFilterToIFilterAdapter(fileFilter));
        }
        return new FilterChainAND<File>(arrayList);
    }

    @Nonnull
    public static IFilter<File> getANDChained(FilenameFilter ... filenameFilterArray) {
        ValueEnforcer.notEmpty(filenameFilterArray, "FilenameFilters");
        ArrayList<FileFilterToIFilterAdapter> arrayList = new ArrayList<FileFilterToIFilterAdapter>();
        for (FilenameFilter filenameFilter : filenameFilterArray) {
            arrayList.add(new FileFilterToIFilterAdapter(filenameFilter));
        }
        return new FilterChainAND<File>(arrayList);
    }

    @Nonnull
    public static IFilter<File> getORChained(FileFilter ... fileFilterArray) {
        ValueEnforcer.notEmpty(fileFilterArray, "FileFilters");
        ArrayList<FileFilterToIFilterAdapter> arrayList = new ArrayList<FileFilterToIFilterAdapter>();
        for (FileFilter fileFilter : fileFilterArray) {
            arrayList.add(new FileFilterToIFilterAdapter(fileFilter));
        }
        return new FilterChainOR<File>(arrayList);
    }

    @Nonnull
    public static IFilter<File> getORChained(FilenameFilter ... filenameFilterArray) {
        ValueEnforcer.notEmpty(filenameFilterArray, "FilenameFilters");
        ArrayList<FileFilterToIFilterAdapter> arrayList = new ArrayList<FileFilterToIFilterAdapter>();
        for (FilenameFilter filenameFilter : filenameFilterArray) {
            arrayList.add(new FileFilterToIFilterAdapter(filenameFilter));
        }
        return new FilterChainOR<File>(arrayList);
    }
}

