/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.filter;

import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FilenameFilter;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FilenameFilterPublicDirectory
implements FilenameFilter {
    private static final FilenameFilterPublicDirectory s_aInstance = new FilenameFilterPublicDirectory();

    private FilenameFilterPublicDirectory() {
    }

    @Override
    public boolean accept(@Nonnull File file, @Nonnull String string) {
        String string2 = FilenameHelper.getSecureFilename(string);
        return new File(file, string2).isDirectory() && !FilenameHelper.isHiddenFilename(string2);
    }

    public String toString() {
        return new ToStringGenerator(this).toString();
    }

    @Nonnull
    public static FilenameFilterPublicDirectory getInstance() {
        return s_aInstance;
    }
}

