/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.monitor;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.io.monitor.FileChangeEvent;
import com.helger.commons.io.monitor.FileMonitorAgent;
import com.helger.commons.io.monitor.IFileListener;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMonitor {
    private static final Logger s_aLogger = LoggerFactory.getLogger(FileMonitor.class);
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final Map<String, FileMonitorAgent> m_aMonitorMap = new HashMap<String, FileMonitorAgent>();
    private final Stack<File> m_aDeleteStack = new Stack();
    private final Stack<File> m_aAddStack = new Stack();
    private boolean m_bRecursive;
    private final IFileListener m_aListener;

    public FileMonitor(@Nonnull IFileListener iFileListener) {
        this.m_aListener = ValueEnforcer.notNull(iFileListener, "Listener");
    }

    public boolean isRecursive() {
        return this.m_bRecursive;
    }

    @Nonnull
    public FileMonitor setRecursive(boolean bl) {
        this.m_bRecursive = bl;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private EChange _recursiveAddFile(@Nonnull File file, boolean bl) {
        File[] fileArray;
        String string = file.getAbsolutePath();
        this.m_aRWLock.readLock().lock();
        try {
            if (this.m_aMonitorMap.containsKey(string)) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aMonitorMap.containsKey(string)) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.m_aMonitorMap.put(string, new FileMonitorAgent(this, file));
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (bl && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                this._recursiveAddFile(file2, true);
            }
        }
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    int getMonitoredFileCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aMonitorMap.size();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Nonnull
    public EChange addMonitoredFile(@Nonnull File file) {
        if (this._recursiveAddFile(file, false).isUnchanged()) {
            return EChange.UNCHANGED;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                this._recursiveAddFile(file2, this.m_bRecursive);
            }
        }
        s_aLogger.info("Added " + (this.m_bRecursive ? "recursive " : "") + "monitoring for file changes in " + file.getAbsolutePath() + " - monitoring " + this.getMonitoredFileCount() + " files and directories in total");
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange removeMonitoredFile(@Nonnull File file) {
        String string = file.getAbsolutePath();
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aMonitorMap.remove(string) == null) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        File file2 = file.getParentFile();
        if (file2 != null) {
            FileMonitorAgent fileMonitorAgent;
            String string2 = file2.getAbsolutePath();
            this.m_aRWLock.readLock().lock();
            try {
                fileMonitorAgent = this.m_aMonitorMap.get(string2);
            }
            finally {
                this.m_aRWLock.readLock().unlock();
            }
            if (fileMonitorAgent != null) {
                fileMonitorAgent.resetChildrenList();
            }
        }
        s_aLogger.info("Removed " + (this.m_bRecursive ? "recursive " : "") + "monitoring for file changes in " + file.getAbsolutePath() + " - monitoring " + this.getMonitoredFileCount() + " files and directories in total");
        return EChange.CHANGED;
    }

    void onFileCreated(@Nonnull File file) {
        try {
            this.m_aListener.onFileCreated(new FileChangeEvent(file));
        }
        catch (Throwable throwable) {
            s_aLogger.error("Failed to invoke onFileCreated listener", throwable);
        }
        this.m_aAddStack.push(file);
    }

    void onFileDeleted(@Nonnull File file) {
        try {
            this.m_aListener.onFileDeleted(new FileChangeEvent(file));
        }
        catch (Throwable throwable) {
            s_aLogger.error("Failed to invoke onFileDeleted listener", throwable);
        }
        this.m_aDeleteStack.push(file);
    }

    void onFileChanged(@Nonnull File file) {
        try {
            this.m_aListener.onFileChanged(new FileChangeEvent(file));
        }
        catch (Throwable throwable) {
            s_aLogger.error("Failed to invoke onFileChanged listener", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    Collection<FileMonitorAgent> getAllAgents() {
        this.m_aRWLock.readLock().lock();
        try {
            List<FileMonitorAgent> list = ContainerHelper.newList(this.m_aMonitorMap.values());
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    void applyPendingRemovals() {
        while (!this.m_aDeleteStack.isEmpty()) {
            this.removeMonitoredFile(this.m_aDeleteStack.pop());
        }
    }

    void applyPendingAdds() {
        while (!this.m_aAddStack.isEmpty()) {
            this.addMonitoredFile(this.m_aAddStack.pop());
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("listener", this.m_aListener).append("recursive", this.m_bRecursive).toString();
    }
}

