/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resolver;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.IInputStreamResolver;
import com.helger.commons.io.IOutputStreamResolver;
import com.helger.commons.io.file.FileUtils;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FileSystemByteStreamResolver
implements IInputStreamResolver,
IOutputStreamResolver {
    private final File m_aBasePath;

    public FileSystemByteStreamResolver(@Nonnull String string) {
        this(new File(string));
    }

    public FileSystemByteStreamResolver(@Nonnull File file) {
        ValueEnforcer.notNull(file, "BasePath");
        if (!file.exists()) {
            throw new IllegalArgumentException("Base path does not exist: " + file);
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Only directories are allowed as base path: " + file);
        }
        this.m_aBasePath = file;
    }

    @Nonnull
    public File getBasePath() {
        return this.m_aBasePath;
    }

    @Override
    @Nullable
    public InputStream getInputStream(@Nonnull String string) {
        return FileUtils.getInputStream(new File(this.m_aBasePath, string));
    }

    @Override
    @Nullable
    public OutputStream getOutputStream(@Nonnull String string, @Nonnull EAppend eAppend) {
        return FileUtils.getOutputStream(new File(this.m_aBasePath, string), eAppend);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FileSystemByteStreamResolver)) {
            return false;
        }
        FileSystemByteStreamResolver fileSystemByteStreamResolver = (FileSystemByteStreamResolver)object;
        return this.m_aBasePath.equals(fileSystemByteStreamResolver.m_aBasePath);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aBasePath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("basePath", this.m_aBasePath).toString();
    }
}

