/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resolver;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.IReaderResolver;
import com.helger.commons.io.IWriterResolver;
import com.helger.commons.io.resolver.FileSystemByteStreamResolver;
import com.helger.commons.io.streams.StreamUtils;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FileSystemCharStreamResolver
implements IReaderResolver,
IWriterResolver {
    private final FileSystemByteStreamResolver m_aByteStreamResolver;
    private final Charset m_aCharset;

    public FileSystemCharStreamResolver(@Nonnull String string, @Nonnull Charset charset) {
        this(new File(string), charset);
    }

    public FileSystemCharStreamResolver(@Nonnull File file, @Nonnull Charset charset) {
        ValueEnforcer.notNull(file, "BasePath");
        if (!file.exists()) {
            throw new IllegalArgumentException("Base path does not exist: " + file);
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Only directories are allowed as base path: " + file);
        }
        this.m_aByteStreamResolver = new FileSystemByteStreamResolver(file);
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
    }

    @Nonnull
    public File getBasePath() {
        return this.m_aByteStreamResolver.getBasePath();
    }

    @Nonnull
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    @Nullable
    public Reader getReader(@Nonnull String string) {
        return StreamUtils.createReader(this.m_aByteStreamResolver.getInputStream(string), this.m_aCharset);
    }

    @Override
    @Nullable
    public Writer getWriter(@Nonnull String string, @Nonnull EAppend eAppend) {
        return StreamUtils.createWriter(this.m_aByteStreamResolver.getOutputStream(string, eAppend), this.m_aCharset);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FileSystemCharStreamResolver)) {
            return false;
        }
        FileSystemCharStreamResolver fileSystemCharStreamResolver = (FileSystemCharStreamResolver)object;
        return this.m_aByteStreamResolver.equals(fileSystemCharStreamResolver.m_aByteStreamResolver) && this.m_aCharset.equals(fileSystemCharStreamResolver.m_aCharset);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aByteStreamResolver).append(this.m_aCharset).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("byteStreamResolver", this.m_aByteStreamResolver).append("charset", this.m_aCharset).toString();
    }
}

