/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streams;

import com.helger.commons.IHasSize;
import com.helger.commons.IHasStringRepresentation;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.DevelopersNote;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.annotations.ReturnsMutableObject;
import java.io.Serializable;
import java.io.Writer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class NonBlockingStringWriter
extends Writer
implements IHasStringRepresentation,
IHasSize,
Serializable {
    private final StringBuilder m_aSB;

    public NonBlockingStringWriter() {
        this.m_aSB = new StringBuilder();
        this.lock = this.m_aSB;
    }

    public NonBlockingStringWriter(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "InitialSize");
        this.m_aSB = new StringBuilder(n);
        this.lock = this.m_aSB;
    }

    @Override
    public void write(int n) {
        this.m_aSB.append((char)n);
    }

    @Override
    public void write(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        if (n2 > 0) {
            this.m_aSB.append(cArray, n, n2);
        }
    }

    @Override
    public void write(@Nullable String string) {
        this.m_aSB.append(string);
    }

    @Override
    public void write(@Nonnull String string, int n, int n2) {
        this.m_aSB.append(string.substring(n, n + n2));
    }

    @Override
    public NonBlockingStringWriter append(CharSequence charSequence) {
        if (charSequence == null) {
            this.write("null");
        } else {
            this.write(charSequence.toString());
        }
        return this;
    }

    @Override
    public NonBlockingStringWriter append(CharSequence charSequence, int n, int n2) {
        CharSequence charSequence2 = charSequence == null ? "null" : charSequence;
        this.write(charSequence2.subSequence(n, n2).toString());
        return this;
    }

    @Override
    public NonBlockingStringWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Nonnull
    @ReturnsMutableObject(reason="design")
    public StringBuilder directGetStringBuilder() {
        return this.m_aSB;
    }

    @Nonnull
    @ReturnsMutableCopy
    public char[] getAsCharArray() {
        int n = this.m_aSB.length();
        char[] cArray = new char[n];
        this.m_aSB.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    @Nonnull
    public String getAsString() {
        return this.m_aSB.toString();
    }

    public void reset() {
        this.m_aSB.setLength(0);
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aSB.length();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aSB.length() == 0;
    }

    @Deprecated
    @DevelopersNote(value="Use getAsString as it is more explicit!")
    public String toString() {
        return this.getAsString();
    }
}

