/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.messagedigest;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.messagedigest.IMessageDigestGenerator;
import com.helger.commons.messagedigest.MessageDigestGeneratorHelper;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

public abstract class AbstractMessageDigestGenerator
implements IMessageDigestGenerator {
    @Override
    @Nonnull
    @Deprecated
    public final IMessageDigestGenerator update(@Nonnull String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notNull(string, "Value");
        ValueEnforcer.notEmpty(string2, "Charset");
        return this.update(CharsetManager.getAsBytes(string, string2));
    }

    @Override
    @Nonnull
    public final IMessageDigestGenerator update(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(string, "Value");
        ValueEnforcer.notNull(charset, "Charset");
        return this.update(CharsetManager.getAsBytes(string, charset));
    }

    @Override
    @Nonnull
    public final IMessageDigestGenerator update(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull(byArray, "Value");
        return this.update(byArray, 0, byArray.length);
    }

    @Override
    public final long getDigestLong() {
        return MessageDigestGeneratorHelper.getLongFromDigest(this.getDigest());
    }

    @Override
    @Nonnull
    public final String getDigestHexString() {
        return MessageDigestGeneratorHelper.getHexValueFromDigest(this.getDigest());
    }
}

