/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.messagedigest;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.messagedigest.EMessageDigestAlgorithm;
import com.helger.commons.messagedigest.MessageDigestGeneratorHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MessageDigestValue {
    private final EMessageDigestAlgorithm m_eAlgorithm;
    private final byte[] m_aDigestBytes;

    public MessageDigestValue(@Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm, @Nonnull @Nonempty byte[] byArray) {
        this.m_eAlgorithm = ValueEnforcer.notNull(eMessageDigestAlgorithm, "Algorithm");
        this.m_aDigestBytes = ArrayHelper.getCopy(ValueEnforcer.notEmpty(byArray, "DigestBytes"));
    }

    @Nonnull
    public EMessageDigestAlgorithm getAlgorithm() {
        return this.m_eAlgorithm;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public byte[] getDigestBytes() {
        return ArrayHelper.getCopy(this.m_aDigestBytes);
    }

    public void writeDigestBytes(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        ValueEnforcer.notNull(outputStream, "OutputStream");
        outputStream.write(this.m_aDigestBytes, 0, this.m_aDigestBytes.length);
    }

    @Nonnull
    @Nonempty
    public String getDigestString() {
        return StringHelper.getHexEncoded(this.m_aDigestBytes);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MessageDigestValue)) {
            return false;
        }
        MessageDigestValue messageDigestValue = (MessageDigestValue)object;
        return this.m_eAlgorithm.equals((Object)messageDigestValue.m_eAlgorithm) && EqualsUtils.equals(this.m_aDigestBytes, messageDigestValue.m_aDigestBytes);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eAlgorithm)).append(this.m_aDigestBytes).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("algorithm", this.m_eAlgorithm).append("bytes", Arrays.toString(this.m_aDigestBytes)).toString();
    }

    @Nonnull
    public static MessageDigestValue create(@Nonnull byte[] byArray, @Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm) {
        byte[] byArray2 = MessageDigestGeneratorHelper.getDigest(byArray, eMessageDigestAlgorithm);
        return new MessageDigestValue(eMessageDigestAlgorithm, byArray2);
    }
}

