/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom;

import com.helger.commons.id.IHasSimpleIntID;
import com.helger.commons.lang.EnumHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public enum EMicroNodeType implements IHasSimpleIntID
{
    CDATA(1, 4),
    COMMENT(2, 8),
    CONTAINER(3),
    DOCUMENT(4, 9),
    DOCUMENT_TYPE(5, 10),
    ELEMENT(6, 1),
    ENTITY_REFERENCE(7, 5),
    PROCESSING_INSTRUCTION(8, 7),
    TEXT(9, 3);

    public static final short ILLEGAL_DOM_NODE_TYPE = 0;
    private final int m_nID;
    private final short m_nDOMNodeType;

    private EMicroNodeType(int n2) {
        this(n2, 0);
    }

    private EMicroNodeType(int n2, short s) {
        this.m_nID = n2;
        this.m_nDOMNodeType = s;
    }

    @Override
    @Nonnegative
    public int getID() {
        return this.m_nID;
    }

    public boolean hasCorrespondingDOMNodeType() {
        return this.m_nDOMNodeType != 0;
    }

    public short getDOMNodeType() {
        return this.m_nDOMNodeType;
    }

    @Nullable
    public static EMicroNodeType getFromIDOrNull(int n) {
        return EnumHelper.getFromIDOrNull(EMicroNodeType.class, n);
    }
}

