/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom.reader;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.IInputStreamProvider;
import com.helger.commons.io.IOutputStreamProvider;
import com.helger.commons.io.streams.StreamUtils;
import com.helger.commons.microdom.IMicroDocument;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.impl.MicroDocument;
import com.helger.commons.microdom.serialize.MicroReader;
import com.helger.commons.microdom.serialize.MicroWriter;
import com.helger.commons.state.ESuccess;
import com.helger.commons.xml.serialize.XMLWriterSettings;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class XMLListHandler {
    public static final String ELEMENT_LIST = "list";
    public static final String ELEMENT_ITEM = "item";
    public static final String ATTR_VALUE = "value";
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLListHandler.class);
    private static final XMLListHandler s_aInstance = new XMLListHandler();

    private XMLListHandler() {
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readList(@Nonnull IInputStreamProvider iInputStreamProvider) {
        ValueEnforcer.notNull(iInputStreamProvider, "InputStreamProvider");
        return XMLListHandler.readList(iInputStreamProvider.getInputStream());
    }

    @Nonnull
    public static ESuccess readList(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull Collection<String> collection) {
        ValueEnforcer.notNull(iInputStreamProvider, "InputStreamProvider");
        return XMLListHandler.readList(iInputStreamProvider.getInputStream(), collection);
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readList(@Nonnull @WillClose InputStream inputStream) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (XMLListHandler.readList(inputStream, arrayList).isFailure()) {
            return null;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess readList(@Nonnull @WillClose InputStream inputStream, @Nonnull Collection<String> collection) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.notNull(collection, "TargetList");
        try {
            IMicroDocument iMicroDocument = MicroReader.readMicroXML(inputStream);
            if (iMicroDocument != null) {
                XMLListHandler.readList(iMicroDocument.getDocumentElement(), collection);
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
        }
        catch (Throwable throwable) {
            s_aLogger.warn("Failed to read list resource '" + inputStream + "'", throwable);
        }
        finally {
            StreamUtils.close(inputStream);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess readList(@Nonnull IMicroElement iMicroElement, @Nonnull Collection<String> collection) {
        ValueEnforcer.notNull(iMicroElement, "ParentElement");
        ValueEnforcer.notNull(collection, "TargetList");
        try {
            for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_ITEM)) {
                String string = iMicroElement2.getAttribute(ATTR_VALUE);
                if (string == null) {
                    s_aLogger.warn("Ignoring list item because value is null");
                    continue;
                }
                if (collection.add(string)) continue;
                s_aLogger.warn("Ignoring list item '" + string + "' because value is already contained");
            }
            return ESuccess.SUCCESS;
        }
        catch (Throwable throwable) {
            s_aLogger.warn("Failed to read list document", throwable);
            return ESuccess.FAILURE;
        }
    }

    @Nonnull
    public static IMicroDocument createListDocument(@Nonnull Collection<String> collection) {
        ValueEnforcer.notNull(collection, "Collection");
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement(ELEMENT_LIST);
        for (String string : collection) {
            IMicroElement iMicroElement2 = iMicroElement.appendElement(ELEMENT_ITEM);
            iMicroElement2.setAttribute(ATTR_VALUE, string);
        }
        return microDocument;
    }

    @Nonnull
    public static ESuccess writeList(@Nonnull Collection<String> collection, @Nonnull IOutputStreamProvider iOutputStreamProvider) {
        ValueEnforcer.notNull(iOutputStreamProvider, "OutputStreamProvider");
        return XMLListHandler.writeList(collection, iOutputStreamProvider.getOutputStream(EAppend.DEFAULT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeList(@Nonnull Collection<String> collection, @Nonnull @WillClose OutputStream outputStream) {
        ValueEnforcer.notNull(collection, "Collection");
        ValueEnforcer.notNull(outputStream, "OutputStream");
        try {
            IMicroDocument iMicroDocument = XMLListHandler.createListDocument(collection);
            ESuccess eSuccess = MicroWriter.writeToStream(iMicroDocument, outputStream, XMLWriterSettings.DEFAULT_XML_SETTINGS);
            return eSuccess;
        }
        finally {
            StreamUtils.close(outputStream);
        }
    }
}

