/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom.serialize;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.microdom.IMicroCDATA;
import com.helger.commons.microdom.IMicroComment;
import com.helger.commons.microdom.IMicroContainer;
import com.helger.commons.microdom.IMicroDocument;
import com.helger.commons.microdom.IMicroDocumentType;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.IMicroEntityReference;
import com.helger.commons.microdom.IMicroNode;
import com.helger.commons.microdom.IMicroProcessingInstruction;
import com.helger.commons.microdom.IMicroText;
import com.helger.commons.string.StringHelper;
import com.helger.commons.xml.IXMLIterationHandler;
import com.helger.commons.xml.XMLHelper;
import com.helger.commons.xml.serialize.AbstractXMLSerializer;
import com.helger.commons.xml.serialize.IXMLWriterSettings;
import com.helger.commons.xml.serialize.XMLWriterSettings;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MicroSerializer
extends AbstractXMLSerializer<IMicroNode> {
    public MicroSerializer() {
        this(XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    public MicroSerializer(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        super(iXMLWriterSettings);
    }

    @Override
    protected void emitNode(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nullable IMicroNode iMicroNode, @Nonnull IMicroNode iMicroNode2, @Nullable IMicroNode iMicroNode3) {
        ValueEnforcer.notNull(iMicroNode2, "Node");
        if (iMicroNode2.isElement()) {
            this._writeElement(iXMLIterationHandler, iMicroNode, (IMicroElement)iMicroNode2, iMicroNode3);
        } else if (iMicroNode2.isText()) {
            MicroSerializer._writeText(iXMLIterationHandler, (IMicroText)iMicroNode2);
        } else if (iMicroNode2.isCDATA()) {
            MicroSerializer._writeCDATA(iXMLIterationHandler, (IMicroCDATA)iMicroNode2);
        } else if (iMicroNode2.isComment()) {
            this._writeComment(iXMLIterationHandler, (IMicroComment)iMicroNode2);
        } else if (iMicroNode2.isEntityReference()) {
            MicroSerializer._writeEntityReference(iXMLIterationHandler, (IMicroEntityReference)iMicroNode2);
        } else if (iMicroNode2.isDocument()) {
            this._writeDocument(iXMLIterationHandler, (IMicroDocument)iMicroNode2);
        } else if (iMicroNode2.isDocumentType()) {
            this._writeDocumentType(iXMLIterationHandler, (IMicroDocumentType)iMicroNode2);
        } else if (iMicroNode2.isProcessingInstruction()) {
            MicroSerializer._writeProcessingInstruction(iXMLIterationHandler, (IMicroProcessingInstruction)iMicroNode2);
        } else if (iMicroNode2.isContainer()) {
            this._writeContainer(iXMLIterationHandler, (IMicroContainer)iMicroNode2);
        } else {
            throw new IllegalArgumentException("Passed node type " + iMicroNode2.getClass().getName() + " is not yet supported");
        }
    }

    private void _writeNodeList(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull List<IMicroNode> list) {
        int n = list.size() - 1;
        for (int i = 0; i <= n; ++i) {
            this.emitNode(iXMLIterationHandler, i == 0 ? null : list.get(i - 1), list.get(i), i == n ? null : list.get(i + 1));
        }
    }

    private void _writeDocument(@Nonnull IXMLIterationHandler iXMLIterationHandler, IMicroDocument iMicroDocument) {
        if (this.m_aSettings.getFormat().isXML()) {
            iXMLIterationHandler.onDocumentStart(this.m_aSettings.getXMLVersion(), this.m_aSettings.getCharset(), iMicroDocument.isStandalone());
        }
        if (iMicroDocument.hasChildren()) {
            this._writeNodeList(iXMLIterationHandler, iMicroDocument.getChildren());
        }
    }

    private void _writeDocumentType(@Nonnull IXMLIterationHandler iXMLIterationHandler, IMicroDocumentType iMicroDocumentType) {
        if (this.m_aSettings.getSerializeDocType().isEmit()) {
            iXMLIterationHandler.onDocumentType(iMicroDocumentType.getQualifiedName(), iMicroDocumentType.getPublicID(), iMicroDocumentType.getSystemID());
        }
    }

    private static void _writeProcessingInstruction(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull IMicroProcessingInstruction iMicroProcessingInstruction) {
        iXMLIterationHandler.onProcessingInstruction(iMicroProcessingInstruction.getTarget(), iMicroProcessingInstruction.getData());
    }

    private void _writeContainer(@Nonnull IXMLIterationHandler iXMLIterationHandler, IMicroContainer iMicroContainer) {
        if (iMicroContainer.hasChildren()) {
            this._writeNodeList(iXMLIterationHandler, iMicroContainer.getChildren());
        }
    }

    private static void _writeEntityReference(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull IMicroEntityReference iMicroEntityReference) {
        iXMLIterationHandler.onEntityReference(iMicroEntityReference.getName());
    }

    private static void _writeText(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull IMicroText iMicroText) {
        iXMLIterationHandler.onText(iMicroText.getData().toString(), iMicroText.isEscape());
    }

    private void _writeComment(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull IMicroComment iMicroComment) {
        if (this.m_aSettings.getSerializeComments().isEmit()) {
            if (this.m_aSettings.getIndent().isIndent() && this.m_aIndent.length() > 0) {
                iXMLIterationHandler.onContentElementWhitespace(this.m_aIndent);
            }
            iXMLIterationHandler.onComment(iMicroComment.getData().toString());
            if (this.m_aSettings.getIndent().isAlign()) {
                iXMLIterationHandler.onContentElementWhitespace(this.m_aSettings.getNewlineString());
            }
        }
    }

    private static void _writeCDATA(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull IMicroCDATA iMicroCDATA) {
        iXMLIterationHandler.onCDATA(iMicroCDATA.getData().toString());
    }

    private static boolean _isInlineNode(@Nonnull IMicroNode iMicroNode) {
        return (iMicroNode.isText() || iMicroNode.isCDATA()) && !iMicroNode.isComment() || iMicroNode.isEntityReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeElement(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nullable IMicroNode iMicroNode, @Nonnull IMicroElement iMicroElement, @Nullable IMicroNode iMicroNode2) {
        String string = iMicroElement.getLocalName() != null ? iMicroElement.getLocalName() : iMicroElement.getTagName();
        boolean bl = this.m_aSettings.isEmitNamespaces();
        List<IMicroNode> list = iMicroElement.getChildren();
        boolean bl2 = iMicroElement.hasChildren();
        boolean bl3 = iMicroElement.getParent() != null && iMicroElement.getParent().isDocument();
        boolean bl4 = iMicroNode == null || !MicroSerializer._isInlineNode(iMicroNode) || bl3;
        boolean bl5 = iMicroNode2 == null || !MicroSerializer._isInlineNode(iMicroNode2);
        boolean bl6 = bl2 && !MicroSerializer._isInlineNode(iMicroElement.getFirstChild());
        Map<String, String> map = iMicroElement.hasAttributes() ? iMicroElement.getAllAttributes() : new LinkedHashMap<String, String>();
        this.m_aNSStack.push(bl ? map : null);
        this.handlePutNamespaceContextPrefixInRoot(map);
        try {
            String string2;
            String string3 = null;
            if (bl) {
                String string4;
                string2 = StringHelper.getNotNull(iMicroElement.getNamespaceURI());
                boolean bl7 = string2.equals(string4 = StringHelper.getNotNull(this.m_aNSStack.getDefaultNamespaceURI()));
                if (!bl7) {
                    string3 = this.m_aNSStack.getUsedPrefixOfNamespace(string2);
                }
                if (!(string3 != null || bl7 || bl3 && string2.length() <= 0)) {
                    string3 = this.m_aNSStack.getMappedPrefix(string2);
                    if (string3 == null && !bl3) {
                        string3 = this.m_aNSStack.createUniquePrefix();
                    }
                    this.m_aNSStack.addNamespaceMapping(string3, string2);
                    map.put(XMLHelper.getXMLNSAttrName(string3), string2);
                }
            }
            if (this.m_aSettings.getIndent().isIndent() && bl4 && this.m_aIndent.length() > 0) {
                iXMLIterationHandler.onContentElementWhitespace(this.m_aIndent);
            }
            iXMLIterationHandler.onElementStart(string3, string, map, bl2);
            if (bl2) {
                if (this.m_aSettings.getIndent().isAlign() && bl6) {
                    iXMLIterationHandler.onContentElementWhitespace(this.m_aSettings.getNewlineString());
                }
                string2 = this.m_aSettings.getIndentationString();
                this.m_aIndent.append(string2);
                if (list != null) {
                    this._writeNodeList(iXMLIterationHandler, list);
                }
                this.m_aIndent.delete(this.m_aIndent.length() - string2.length(), this.m_aIndent.length());
                if (this.m_aSettings.getIndent().isIndent() && bl6 && this.m_aIndent.length() > 0) {
                    iXMLIterationHandler.onContentElementWhitespace(this.m_aIndent);
                }
            }
            iXMLIterationHandler.onElementEnd(string3, string, bl2);
            if (this.m_aSettings.getIndent().isAlign() && bl5) {
                iXMLIterationHandler.onContentElementWhitespace(this.m_aSettings.getNewlineString());
            }
        }
        finally {
            this.m_aNSStack.pop();
        }
    }
}

