/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.IChangeNotify;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.locale.LocaleUtils;
import com.helger.commons.state.EChange;
import com.helger.commons.text.IMultiLingualText;
import com.helger.commons.text.IReadonlyMultiLingualText;
import com.helger.commons.text.ISimpleMultiLingualText;
import com.helger.commons.text.impl.TextProvider;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MultiLingualText
extends TextProvider
implements IMultiLingualText {
    private static final long serialVersionUID = 136888667633487L;
    public static final IMultiLingualText EMPTY_MULTILINGUAL_TEXT = new MultiLingualText();
    private final CallbackList<IChangeNotify<IMultiLingualText>> m_aChangeNotifyCallbacks = new CallbackList();

    public MultiLingualText() {
    }

    public MultiLingualText(@Nonnull Locale locale, @Nonnull String string) {
        this.internalAddText(locale, string);
    }

    public MultiLingualText(@Nonnull ISimpleMultiLingualText iSimpleMultiLingualText) {
        ValueEnforcer.notNull(iSimpleMultiLingualText, "SimpleMLT");
        for (Locale locale : iSimpleMultiLingualText.getAllLocales()) {
            this.internalAddText(locale, iSimpleMultiLingualText.getText(locale));
        }
    }

    public MultiLingualText(@Nonnull IReadonlyMultiLingualText iReadonlyMultiLingualText) {
        ValueEnforcer.notNull(iReadonlyMultiLingualText, "MLT");
        for (Map.Entry<Locale, String> entry : iReadonlyMultiLingualText.getMap().entrySet()) {
            this.internalAddText(entry.getKey(), entry.getValue());
        }
    }

    private boolean _beforeChange() {
        for (IChangeNotify<IMultiLingualText> iChangeNotify : this.m_aChangeNotifyCallbacks.getAllCallbacks()) {
            if (!iChangeNotify.beforeChange(this).isBreak()) continue;
            return false;
        }
        return true;
    }

    private void _afterChange() {
        for (IChangeNotify<IMultiLingualText> iChangeNotify : this.m_aChangeNotifyCallbacks.getAllCallbacks()) {
            iChangeNotify.afterChange(this);
        }
    }

    @Override
    @Nonnull
    public EChange addText(@Nonnull Locale locale, @Nullable String string) {
        ValueEnforcer.notNull(locale, "ContentLocale");
        if (super.containsLocale(locale)) {
            return EChange.UNCHANGED;
        }
        if (!this._beforeChange()) {
            return EChange.UNCHANGED;
        }
        this.internalAddText(locale, string);
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange setText(@Nonnull Locale locale, @Nullable String string) {
        ValueEnforcer.notNull(locale, "ContentLocale");
        if (this.containsLocale(locale)) {
            String string2 = super.internalGetText(locale);
            if (EqualsUtils.equals(string2, string)) {
                return EChange.UNCHANGED;
            }
            if (!this._beforeChange()) {
                return EChange.UNCHANGED;
            }
            this.internalSetText(locale, string);
            this._afterChange();
            return EChange.CHANGED;
        }
        if (!this._beforeChange()) {
            return EChange.UNCHANGED;
        }
        this.internalAddText(locale, string);
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange removeText(@Nonnull Locale locale) {
        for (Locale locale2 : LocaleUtils.getCalculatedLocaleListForResolving(locale)) {
            if (!super.containsLocale(locale2)) continue;
            if (!this._beforeChange()) {
                return EChange.UNCHANGED;
            }
            this.internalRemoveText(locale2);
            this._afterChange();
            return EChange.CHANGED;
        }
        return EChange.UNCHANGED;
    }

    @Override
    @Nonnull
    public EChange clear() {
        if (!this.isEmpty() && this._beforeChange()) {
            this.internalClear();
            this._afterChange();
            return EChange.CHANGED;
        }
        return EChange.UNCHANGED;
    }

    @Override
    @Nonnull
    public EChange assignFrom(@Nonnull IReadonlyMultiLingualText iReadonlyMultiLingualText) {
        ValueEnforcer.notNull(iReadonlyMultiLingualText, "MLT");
        if (this.getMap().equals(iReadonlyMultiLingualText.getMap()) || !this._beforeChange()) {
            return EChange.UNCHANGED;
        }
        this.internalClear();
        for (Map.Entry<Locale, String> entry : iReadonlyMultiLingualText.getMap().entrySet()) {
            this.internalAddText(entry.getKey(), entry.getValue());
        }
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject(reason="design")
    public CallbackList<IChangeNotify<IMultiLingualText>> getChangeNotifyCallbacks() {
        return this.m_aChangeNotifyCallbacks;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Nonnull
    public static IMultiLingualText createFromMap(@Nonnull Map<String, String> map) {
        MultiLingualText multiLingualText = new MultiLingualText();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getValue();
            if (string == null) continue;
            multiLingualText.setText(LocaleCache.getLocale(entry.getKey()), string);
        }
        return multiLingualText;
    }

    @Nonnull
    public static IMultiLingualText getCopyWithLocales(@Nonnull IReadonlyMultiLingualText iReadonlyMultiLingualText, @Nonnull Collection<Locale> collection) {
        MultiLingualText multiLingualText = new MultiLingualText();
        for (Locale locale : collection) {
            if (!iReadonlyMultiLingualText.containsLocale(locale)) continue;
            multiLingualText.setText(locale, iReadonlyMultiLingualText.getText(locale));
        }
        return multiLingualText;
    }
}

