/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.impl;

import com.helger.commons.GlobalDebug;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.annotations.ReturnsMutableObject;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.locale.LocaleUtils;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.IReadonlyMultiLingualText;
import com.helger.commons.text.impl.AbstractTextProvider;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextProvider
extends AbstractTextProvider
implements IReadonlyMultiLingualText {
    public static final Locale DE = LocaleCache.getLocale("de");
    public static final Locale EN = LocaleCache.getLocale("en");
    private static final Logger s_aLogger = LoggerFactory.getLogger(TextProvider.class);
    private static final AtomicBoolean s_aConsistencyChecksEnabled = new AtomicBoolean(GlobalDebug.isDebugMode());
    private final Map<Locale, String> m_aTexts = new HashMap<Locale, String>();

    public static void setPerformConsistencyChecks(boolean bl) {
        s_aConsistencyChecksEnabled.set(bl);
    }

    public static boolean isPerformConsistencyChecks() {
        return s_aConsistencyChecksEnabled.get();
    }

    private static void _performConsistencyChecks(@Nonnull String string) {
        if (string.contains("\\n")) {
            s_aLogger.warn("Passed string contains a masked newline - replace with an inline one:\n" + string);
        }
        if (string.contains("{0}")) {
            if (RegExHelper.stringMatchesPattern("^'[^'].*", string)) {
                throw new IllegalArgumentException("The passed string seems to start with unclosed single quotes: " + string);
            }
            if (RegExHelper.stringMatchesPattern(".*[^']'[^'].*", string)) {
                throw new IllegalArgumentException("The passed string seems to contain unclosed single quotes: " + string);
            }
        } else if (RegExHelper.stringMatchesPattern(".*''.*", string)) {
            throw new IllegalArgumentException("The passed string seems to contain 2 single quotes: " + string);
        }
    }

    @Nonnull
    protected final TextProvider internalAddText(@Nonnull Locale locale, @Nonnull String string) {
        if (this.m_aTexts.containsKey(locale)) {
            throw new IllegalArgumentException("Locale '" + locale + "' already contained in TextProvider: " + this.toString());
        }
        return this.internalSetText(locale, string);
    }

    @Nonnull
    protected final TextProvider internalSetText(@Nonnull Locale locale, @Nullable String string) {
        ValueEnforcer.notNull(locale, "ContentLocale");
        if (string != null && s_aConsistencyChecksEnabled.get()) {
            TextProvider._performConsistencyChecks(string);
        }
        this.m_aTexts.put(locale, string);
        return this;
    }

    @Nonnull
    protected final EChange internalRemoveText(@Nullable Locale locale) {
        return EChange.valueOf(this.m_aTexts.remove(locale) != null);
    }

    @Nonnull
    protected final EChange internalClear() {
        if (this.m_aTexts.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aTexts.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    public final TextProvider addTextDE(@Nonnull String string) {
        return this.internalAddText(DE, string);
    }

    @Nonnull
    public final TextProvider addTextEN(@Nonnull String string) {
        return this.internalAddText(EN, string);
    }

    @Nonnull
    @ReturnsMutableObject(reason="Internal use only")
    protected final Map<Locale, String> internalGetMap() {
        return this.m_aTexts;
    }

    @Override
    @Nullable
    protected final Locale internalGetLocaleToUseWithFallback(@Nonnull Locale locale) {
        return LocaleUtils.getLocaleToUseOrNull(locale, this.m_aTexts.keySet());
    }

    @Override
    @Nullable
    @OverrideOnDemand
    protected String internalGetText(@Nonnull Locale locale) {
        return this.m_aTexts.get(locale);
    }

    @Nonnull
    @ReturnsMutableObject(reason="Internal use only")
    public final Set<Locale> internalGetAllLocales() {
        return this.m_aTexts.keySet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public final Set<Locale> getAllLocales() {
        return ContainerHelper.newSet(this.m_aTexts.keySet());
    }

    @Override
    @Nonnegative
    public final int getLocaleCount() {
        return this.m_aTexts.size();
    }

    @Override
    public final boolean containsLocale(@Nullable Locale locale) {
        return this.m_aTexts.containsKey(locale);
    }

    @Override
    public final boolean containsLocaleWithFallback(@Nullable Locale locale) {
        if (locale != null) {
            for (Locale locale2 : LocaleUtils.getCalculatedLocaleListForResolving(locale)) {
                if (!this.containsLocale(locale2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final Map<Locale, String> getMap() {
        return ContainerHelper.newMap(this.m_aTexts);
    }

    @Override
    @Nonnegative
    public final int size() {
        return this.m_aTexts.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.m_aTexts.isEmpty();
    }

    @OverridingMethodsMustInvokeSuper
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        TextProvider textProvider = (TextProvider)object;
        return this.m_aTexts.equals(textProvider.m_aTexts);
    }

    @OverridingMethodsMustInvokeSuper
    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aTexts)).getHashCode();
    }

    @OverridingMethodsMustInvokeSuper
    public String toString() {
        return new ToStringGenerator(this).append("texts", this.m_aTexts).toString();
    }

    @Nonnull
    public static TextProvider create_DE(@Nonnull String string) {
        return new TextProvider().addTextDE(string);
    }

    @Nonnull
    public static TextProvider create_EN(@Nonnull String string) {
        return new TextProvider().addTextEN(string);
    }

    @Nonnull
    public static TextProvider create_DE_EN(@Nonnull String string, @Nonnull String string2) {
        return new TextProvider().addTextDE(string).addTextEN(string2);
    }
}

