/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.resource;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CCharset;
import com.helger.commons.charset.CharsetManager;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;

final class Utf8PropertyResourceBundle
extends ResourceBundle {
    private final PropertyResourceBundle m_aBundle;

    Utf8PropertyResourceBundle(@Nonnull PropertyResourceBundle propertyResourceBundle) {
        this.m_aBundle = ValueEnforcer.notNull(propertyResourceBundle, "Bundle");
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.m_aBundle.getKeys();
    }

    @Override
    protected Object handleGetObject(String string) {
        String string2 = this.m_aBundle.getString(string);
        return CharsetManager.getAsStringInOtherCharset(string2, CCharset.CHARSET_ISO_8859_1_OBJ, CCharset.CHARSET_UTF_8_OBJ);
    }
}

