/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.thirdparty;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.thirdparty.ILicense;
import com.helger.commons.version.Version;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CustomLicense
implements ILicense {
    private final String m_sID;
    private final String m_sName;
    private final Version m_aVersion;
    private final String m_sWebSiteURL;

    public CustomLicense(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable Version version, @Nullable String string3) {
        this.m_sID = ValueEnforcer.notEmpty(string, "ID");
        this.m_sName = ValueEnforcer.notEmpty(string2, "Name");
        this.m_aVersion = version;
        this.m_sWebSiteURL = string3;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sName;
    }

    @Override
    @Nullable
    public Version getVersion() {
        return this.m_aVersion;
    }

    @Override
    @Nullable
    public String getURL() {
        return this.m_sWebSiteURL;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CustomLicense)) {
            return false;
        }
        CustomLicense customLicense = (CustomLicense)object;
        return this.m_sID.equals(customLicense.m_sID) && this.m_sName.equals(customLicense.m_sName) && EqualsUtils.equals(this.m_aVersion, customLicense.m_aVersion) && EqualsUtils.equals(this.m_sWebSiteURL, customLicense.m_sWebSiteURL);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sID).append(this.m_sName).append(this.m_aVersion).append(this.m_sWebSiteURL).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_sID).append("name", this.m_sName).appendIfNotNull("version", this.m_aVersion).appendIfNotNull("website", this.m_sWebSiteURL).toString();
    }
}

