/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.serialize;

import com.helger.commons.string.StringHelper;
import com.helger.commons.xml.EXMLVersion;
import com.helger.commons.xml.IXMLIterationHandler;
import com.helger.commons.xml.XMLHelper;
import com.helger.commons.xml.serialize.AbstractXMLSerializer;
import com.helger.commons.xml.serialize.IXMLWriterSettings;
import com.helger.commons.xml.serialize.XMLWriterSettings;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class XMLSerializerPH
extends AbstractXMLSerializer<Node> {
    public XMLSerializerPH() {
        this(XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    public XMLSerializerPH(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        super(iXMLWriterSettings);
    }

    @Override
    protected void emitNode(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nullable Node node, @Nonnull Node node2, @Nullable Node node3) {
        short s = node2.getNodeType();
        if (s == 1) {
            this._writeElement(iXMLIterationHandler, node, (Element)node2, node3);
        } else if (s == 3) {
            XMLSerializerPH._writeText(iXMLIterationHandler, (Text)node2);
        } else if (s == 4) {
            XMLSerializerPH._writeCDATA(iXMLIterationHandler, (CDATASection)node2);
        } else if (s == 8) {
            this._writeComment(iXMLIterationHandler, (Comment)node2);
        } else if (s == 5) {
            XMLSerializerPH._writeEntityReference(iXMLIterationHandler, (EntityReference)node2);
        } else if (s == 9) {
            this._writeDocument(iXMLIterationHandler, (Document)node2);
        } else if (s == 10) {
            this._writeDocumentType(iXMLIterationHandler, (DocumentType)node2);
        } else if (s == 7) {
            XMLSerializerPH._writeProcessingInstruction(iXMLIterationHandler, (ProcessingInstruction)node2);
        } else {
            throw new IllegalArgumentException("Passed node type " + s + " is not yet supported");
        }
    }

    private void _writeNodeList(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull NodeList nodeList) {
        int n = nodeList.getLength() - 1;
        for (int i = 0; i <= n; ++i) {
            this.emitNode(iXMLIterationHandler, i == 0 ? null : nodeList.item(i - 1), nodeList.item(i), i == n ? null : nodeList.item(i + 1));
        }
    }

    private void _writeDocument(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull Document document) {
        if (this.m_aSettings.getFormat().isXML()) {
            String string = null;
            boolean bl = false;
            try {
                string = document.getXmlVersion();
                bl = document.getXmlStandalone();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            EXMLVersion eXMLVersion = EXMLVersion.getFromVersionOrDefault(string, this.m_aSettings.getXMLVersion());
            iXMLIterationHandler.onDocumentStart(eXMLVersion, this.m_aSettings.getCharset(), bl || document.getDoctype() == null);
        }
        this._writeNodeList(iXMLIterationHandler, document.getChildNodes());
    }

    private void _writeDocumentType(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull DocumentType documentType) {
        if (this.m_aSettings.getSerializeDocType().isEmit()) {
            iXMLIterationHandler.onDocumentType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        }
    }

    private static void _writeProcessingInstruction(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull ProcessingInstruction processingInstruction) {
        iXMLIterationHandler.onProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
    }

    private static void _writeEntityReference(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull EntityReference entityReference) {
        iXMLIterationHandler.onEntityReference(entityReference.getNodeName());
    }

    private void _writeComment(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull Comment comment) {
        if (this.m_aSettings.getSerializeComments().isEmit()) {
            iXMLIterationHandler.onComment(comment.getData());
        }
    }

    private static void _writeText(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull Text text) {
        iXMLIterationHandler.onText(text.getData(), true);
    }

    private static void _writeCDATA(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nonnull Text text) {
        iXMLIterationHandler.onCDATA(text.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeElement(@Nonnull IXMLIterationHandler iXMLIterationHandler, @Nullable Node node, @Nonnull Element element, @Nullable Node node2) {
        Object object;
        String string = element.getLocalName() != null ? element.getLocalName() : element.getTagName();
        Document document = element.getOwnerDocument();
        boolean bl = this.m_aSettings.isEmitNamespaces();
        NodeList nodeList = element.getChildNodes();
        boolean bl2 = nodeList.getLength() > 0;
        boolean bl3 = document != null && element.equals(document.getDocumentElement());
        boolean bl4 = node == null || !XMLHelper.isTextNode(node) || bl3;
        boolean bl5 = node2 == null || !XMLHelper.isTextNode(node2);
        boolean bl6 = bl2 && !XMLHelper.isTextNode(element.getFirstChild());
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = (Attr)namedNodeMap.item(i);
            treeMap.put(object.getName(), object.getValue());
        }
        this.m_aNSStack.push(bl ? treeMap : null);
        this.handlePutNamespaceContextPrefixInRoot(treeMap);
        try {
            String string2 = null;
            if (bl) {
                String string3;
                object = StringHelper.getNotNull(element.getNamespaceURI());
                boolean bl7 = ((String)object).equals(string3 = StringHelper.getNotNull(this.m_aNSStack.getDefaultNamespaceURI()));
                if (!bl7) {
                    string2 = this.m_aNSStack.getUsedPrefixOfNamespace((String)object);
                }
                if (!(string2 != null || bl7 || bl3 && ((String)object).length() <= 0)) {
                    string2 = this.m_aNSStack.getMappedPrefix((String)object);
                    if (string2 == null && !bl3) {
                        string2 = this.m_aNSStack.createUniquePrefix();
                    }
                    treeMap.put(XMLHelper.getXMLNSAttrName(string2), (String)object);
                    this.m_aNSStack.addNamespaceMapping(string2, (String)object);
                }
            }
            if (this.m_aSettings.getIndent().isIndent() && bl4 && this.m_aIndent.length() > 0) {
                iXMLIterationHandler.onContentElementWhitespace(this.m_aIndent);
            }
            iXMLIterationHandler.onElementStart(string2, string, treeMap, bl2);
            if (bl2) {
                if (this.m_aSettings.getIndent().isAlign() && bl6) {
                    iXMLIterationHandler.onContentElementWhitespace(this.m_aSettings.getNewlineString());
                }
                object = this.m_aSettings.getIndentationString();
                this.m_aIndent.append((String)object);
                this._writeNodeList(iXMLIterationHandler, nodeList);
                this.m_aIndent.delete(this.m_aIndent.length() - ((String)object).length(), this.m_aIndent.length());
                if (this.m_aSettings.getIndent().isIndent() && bl6 && this.m_aIndent.length() > 0) {
                    iXMLIterationHandler.onContentElementWhitespace(this.m_aIndent);
                }
            }
            iXMLIterationHandler.onElementEnd(string2, string, bl2);
            if (this.m_aSettings.getIndent().isAlign() && bl5) {
                iXMLIterationHandler.onContentElementWhitespace(this.m_aSettings.getNewlineString());
            }
        }
        finally {
            this.m_aNSStack.pop();
        }
    }
}

