/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.xpath;

import com.helger.commons.ICloneable;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.xpath.XPathFunctionKey;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;

@NotThreadSafe
public class MapBasedXPathFunctionResolver
implements XPathFunctionResolver,
ICloneable<MapBasedXPathFunctionResolver> {
    private final Map<XPathFunctionKey, XPathFunction> m_aVars;

    public MapBasedXPathFunctionResolver() {
        this.m_aVars = new HashMap<XPathFunctionKey, XPathFunction>();
    }

    public MapBasedXPathFunctionResolver(@Nonnull MapBasedXPathFunctionResolver mapBasedXPathFunctionResolver) {
        ValueEnforcer.notNull(mapBasedXPathFunctionResolver, "Other");
        this.m_aVars = ContainerHelper.newMap(mapBasedXPathFunctionResolver.m_aVars);
    }

    @Nonnull
    public EChange addUniqueFunction(@Nonnull String string, @Nonnull String string2, @Nonnegative int n, @Nonnull XPathFunction xPathFunction) {
        return this.addUniqueFunction(new QName(string, string2), n, xPathFunction);
    }

    @Nonnull
    public EChange addUniqueFunction(@Nonnull QName qName, @Nonnegative int n, @Nonnull XPathFunction xPathFunction) {
        ValueEnforcer.notNull(xPathFunction, "Function");
        XPathFunctionKey xPathFunctionKey = new XPathFunctionKey(qName, n);
        if (this.m_aVars.containsKey(xPathFunctionKey)) {
            return EChange.UNCHANGED;
        }
        this.m_aVars.put(xPathFunctionKey, xPathFunction);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeFunction(@Nonnull QName qName, @Nonnegative int n) {
        XPathFunctionKey xPathFunctionKey = new XPathFunctionKey(qName, n);
        return this.removeFunction(xPathFunctionKey);
    }

    @Nonnull
    public EChange removeFunction(@Nullable XPathFunctionKey xPathFunctionKey) {
        return EChange.valueOf(this.m_aVars.remove(xPathFunctionKey) != null);
    }

    @Nonnull
    public EChange removeFunctionsWithName(@Nullable QName qName) {
        EChange eChange = EChange.UNCHANGED;
        if (qName != null) {
            for (XPathFunctionKey xPathFunctionKey : ContainerHelper.newList(this.m_aVars.keySet())) {
                if (!xPathFunctionKey.getFunctionName().equals(qName)) continue;
                eChange = eChange.or(this.removeFunction(xPathFunctionKey));
            }
        }
        return eChange;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Map<XPathFunctionKey, XPathFunction> getAllFunctions() {
        return ContainerHelper.newMap(this.m_aVars);
    }

    @Nonnegative
    public int getFunctionCount() {
        return this.m_aVars.size();
    }

    @Nonnull
    public EChange clear() {
        if (this.m_aVars.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aVars.clear();
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public XPathFunction resolveFunction(@Nonnull QName qName, @Nonnegative int n) {
        return this.resolveFunction(new XPathFunctionKey(qName, n));
    }

    @Nullable
    public XPathFunction resolveFunction(@Nullable XPathFunctionKey xPathFunctionKey) {
        return this.m_aVars.get(xPathFunctionKey);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public MapBasedXPathFunctionResolver getClone() {
        return new MapBasedXPathFunctionResolver(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedXPathFunctionResolver mapBasedXPathFunctionResolver = (MapBasedXPathFunctionResolver)object;
        return EqualsUtils.equals(this.m_aVars, mapBasedXPathFunctionResolver.m_aVars);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aVars)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("vars", this.m_aVars).toString();
    }
}

