/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.aggregate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.aggregate.IAggregator;
import com.helger.commons.aggregate.IAggregatorFactory;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class AggregatorFactoryConst<SRCTYPE, DSTTYPE>
implements IAggregatorFactory<SRCTYPE, DSTTYPE> {
    private final IAggregator<SRCTYPE, DSTTYPE> m_aAggregator;

    public AggregatorFactoryConst(@Nonnull IAggregator<SRCTYPE, DSTTYPE> iAggregator) {
        this.m_aAggregator = ValueEnforcer.notNull(iAggregator, "aAggregator");
    }

    @Override
    @Nonnull
    public IAggregator<SRCTYPE, DSTTYPE> create() {
        return this.m_aAggregator;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AggregatorFactoryConst)) {
            return false;
        }
        AggregatorFactoryConst aggregatorFactoryConst = (AggregatorFactoryConst)object;
        return this.m_aAggregator.equals(aggregatorFactoryConst.m_aAggregator);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aAggregator).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("aggregator", this.m_aAggregator).toString();
    }
}

