/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.flags;

import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.flags.FlagContainer;
import com.helger.commons.collections.flags.IReadonlyFlagContainer;
import com.helger.commons.state.EChange;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FlagContainerThreadSafe
extends FlagContainer {
    protected final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();

    public FlagContainerThreadSafe() {
    }

    public FlagContainerThreadSafe(@Nonnull Collection<String> collection) {
        super(collection);
    }

    public FlagContainerThreadSafe(String ... stringArray) {
        super(stringArray);
    }

    public FlagContainerThreadSafe(@Nonnull IReadonlyFlagContainer iReadonlyFlagContainer) {
        super(iReadonlyFlagContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsFlag(@Nullable String string) {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = super.containsFlag(string);
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllFlags() {
        this.m_aRWLock.readLock().lock();
        try {
            Set<String> set = super.getAllFlags();
            return set;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange addFlag(@Nonnull String string) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = super.addFlag(string);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange removeFlag(@Nullable String string) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = super.removeFlag(string);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnegative
    public int getFlagCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = super.getFlagCount();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsNoFlag() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = super.containsNoFlag();
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange clear() {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = super.clear();
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = super.equals(object);
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = super.hashCode();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.m_aRWLock.readLock().lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }
}

