/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.iterate;

import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class SingleElementEnumeration<ELEMENTTYPE>
implements Enumeration<ELEMENTTYPE> {
    private boolean m_bHasMoreElements = true;
    private final ELEMENTTYPE m_aElement;

    public SingleElementEnumeration(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        this.m_aElement = ELEMENTTYPE;
    }

    @Override
    public boolean hasMoreElements() {
        return this.m_bHasMoreElements;
    }

    @Override
    @Nullable
    public ELEMENTTYPE nextElement() {
        if (this.m_bHasMoreElements) {
            this.m_bHasMoreElements = false;
            return this.m_aElement;
        }
        throw new NoSuchElementException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SingleElementEnumeration)) {
            return false;
        }
        SingleElementEnumeration singleElementEnumeration = (SingleElementEnumeration)object;
        return this.m_bHasMoreElements == singleElementEnumeration.m_bHasMoreElements && EqualsUtils.equals(this.m_aElement, singleElementEnumeration.m_aElement);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_bHasMoreElements).append(this.m_aElement).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("hasMoreElements", this.m_bHasMoreElements).append("element", this.m_aElement).toString();
    }

    @Nonnull
    public static <T> Enumeration<T> create(@Nullable T t) {
        return new SingleElementEnumeration<T>(t);
    }
}

