/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.pair;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ReadonlyIntPair {
    private final int m_aFirst;
    private final int m_aSecond;

    public ReadonlyIntPair(int n, int n2) {
        this.m_aFirst = n;
        this.m_aSecond = n2;
    }

    public ReadonlyIntPair(@Nonnull ReadonlyIntPair readonlyIntPair) {
        ValueEnforcer.notNull(readonlyIntPair, "Pair");
        this.m_aFirst = readonlyIntPair.getFirst();
        this.m_aSecond = readonlyIntPair.getSecond();
    }

    public int getFirst() {
        return this.m_aFirst;
    }

    public int getSecond() {
        return this.m_aSecond;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ReadonlyIntPair)) {
            return false;
        }
        ReadonlyIntPair readonlyIntPair = (ReadonlyIntPair)object;
        return this.m_aFirst == readonlyIntPair.m_aFirst && this.m_aSecond == readonlyIntPair.m_aSecond;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aFirst).append(this.m_aSecond).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("first", this.m_aFirst).append("second", this.m_aSecond).toString();
    }
}

