/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.io.file.filter.AbstractFileFilter;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FilenameFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FileFilterFromFilenameFilter
extends AbstractFileFilter {
    private final FilenameFilter m_aFilenameFilter;

    public FileFilterFromFilenameFilter(@Nonnull FilenameFilter filenameFilter) {
        this.m_aFilenameFilter = ValueEnforcer.notNull(filenameFilter, "FilenameFilter");
    }

    @Nonnull
    public final FilenameFilter getFilenameFilter() {
        return this.m_aFilenameFilter;
    }

    @Override
    public boolean matchesFilter(@Nullable File file) {
        return file != null && this.m_aFilenameFilter.accept(file.getParentFile(), file.getName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof FileFilterFromFilenameFilter;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("filenameFilter", this.m_aFilenameFilter).toString();
    }
}

