/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.filter.AbstractFileFilter;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FilenameFilterStartsWith
extends AbstractFileFilter {
    private final String m_sPrefix;

    public FilenameFilterStartsWith(@Nonnull @Nonempty String string) {
        this.m_sPrefix = ValueEnforcer.notEmpty(string, "Prefix");
    }

    @Nonnull
    @Nonempty
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Override
    public boolean matchesFilter(@Nullable File file) {
        return file != null && FilenameHelper.getSecureFilename(file.getName()).startsWith(this.m_sPrefix);
    }

    public String toString() {
        return new ToStringGenerator(this).append("prefix", this.m_sPrefix).toString();
    }
}

