/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.iterate;

import com.helger.commons.collections.iterate.IIterableIterator;
import com.helger.commons.collections.iterate.IterableIterator;
import com.helger.commons.filter.FilterChainAND;
import com.helger.commons.filter.IFilter;
import com.helger.commons.filter.collections.FilterIterator;
import com.helger.commons.io.file.FileUtils;
import com.helger.commons.io.file.filter.IFileFilter;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class FileSystemIterator
extends IterableIterator<File> {
    public FileSystemIterator(@Nonnull String string) {
        this(new File(string));
    }

    public FileSystemIterator(@Nonnull File file) {
        super(FileUtils.getDirectoryContent(file));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String string, @Nonnull IFilter<File> iFilter) {
        return new FilterIterator<File>(new FileSystemIterator(string), iFilter);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File file, @Nonnull IFilter<File> iFilter) {
        return new FilterIterator<File>(new FileSystemIterator(file), iFilter);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String string, IFileFilter ... iFileFilterArray) {
        return new FilterIterator<File>(new FileSystemIterator(string), (IFilter<File>)new FilterChainAND(iFileFilterArray));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File file, IFileFilter ... iFileFilterArray) {
        return new FilterIterator<File>(new FileSystemIterator(file), (IFilter<File>)new FilterChainAND(iFileFilterArray));
    }
}

