/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.collections.iterate.IIterableIterator;
import com.helger.commons.filter.FilterChainAND;
import com.helger.commons.filter.IFilter;
import com.helger.commons.filter.collections.FilterIterator;
import com.helger.commons.io.file.FileUtils;
import com.helger.commons.io.file.filter.IFileFilter;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileSystemRecursiveIterator
implements IIterableIterator<File> {
    private final int m_nStartLevel;
    private int m_nLevel = 0;
    private final IFilter<File> m_aRecursionFilter;
    private final List<File> m_aFilesLeft;

    @Nonnegative
    private static int _getLevel(@Nonnull File file) {
        return StringHelper.getCharCount(file.getAbsolutePath(), File.separatorChar);
    }

    public FileSystemRecursiveIterator(@Nonnull String string) {
        this(new File(string), (IFilter<File>)null);
    }

    public FileSystemRecursiveIterator(@Nonnull File file) {
        this(file, (IFilter<File>)null);
    }

    public FileSystemRecursiveIterator(@Nonnull String string, @Nullable IFilter<File> iFilter) {
        this(new File(string), iFilter);
    }

    public FileSystemRecursiveIterator(@Nonnull File file, @Nullable IFilter<File> iFilter) {
        ValueEnforcer.notNull(file, "BaseDirectory");
        this.m_nStartLevel = FileSystemRecursiveIterator._getLevel(file);
        this.m_aRecursionFilter = iFilter;
        this.m_aFilesLeft = FileUtils.getDirectoryContent(file);
    }

    @Override
    @Nonnull
    public final Iterator<File> iterator() {
        return this;
    }

    @Override
    public final boolean hasNext() {
        return !this.m_aFilesLeft.isEmpty();
    }

    @OverrideOnDemand
    protected boolean recurseIntoDirectory(@Nonnull File file) {
        return this.m_aRecursionFilter == null || this.m_aRecursionFilter.matchesFilter(file);
    }

    @Override
    @Nonnull
    public final File next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        File file = this.m_aFilesLeft.remove(0);
        this.m_nLevel = FileSystemRecursiveIterator._getLevel(file) - this.m_nStartLevel;
        if (file.isDirectory() && this.recurseIntoDirectory(file)) {
            this.m_aFilesLeft.addAll(0, FileUtils.getDirectoryContent(file));
        }
        return file;
    }

    @Nonnegative
    public final int getLevel() {
        return this.m_nLevel;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return new ToStringGenerator(this).append("files", this.m_aFilesLeft).toString();
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String string, @Nonnull IFilter<File> iFilter) {
        return FileSystemRecursiveIterator.create(new File(string), iFilter);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File file, @Nonnull IFilter<File> iFilter) {
        return new FilterIterator<File>(new FileSystemRecursiveIterator(file), iFilter);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String string, IFileFilter ... iFileFilterArray) {
        return FileSystemRecursiveIterator.create(new File(string), iFileFilterArray);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File file, IFileFilter ... iFileFilterArray) {
        return new FilterIterator<File>(new FileSystemRecursiveIterator(file), (IFilter<File>)new FilterChainAND(iFileFilterArray));
    }
}

