/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.jmx;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.exceptions.LoggedRuntimeException;
import com.helger.commons.lang.CGStringHelper;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.JMException;
import javax.management.ObjectName;

@ThreadSafe
public final class ObjectNameUtils {
    private static final ObjectNameUtils s_aInstance = new ObjectNameUtils();
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static String s_sDefaultJMXDomain = "com.helger";

    private ObjectNameUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultJMXDomain(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "DefaultJMXDomain");
        if (string.indexOf(58) >= 0 || string.indexOf(32) >= 0) {
            throw new IllegalArgumentException("defaultJMXDomain contains invalid chars: " + string);
        }
        s_aRWLock.writeLock().lock();
        try {
            s_sDefaultJMXDomain = string;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @Nonempty
    public static String getDefaultJMXDomain() {
        s_aRWLock.readLock().lock();
        try {
            String string = s_sDefaultJMXDomain;
            return string;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    @Nonnull
    public static ObjectName create(@Nonnull @Nonempty Hashtable<String, String> hashtable) {
        ValueEnforcer.notEmpty(hashtable, "Params");
        try {
            return new ObjectName(ObjectNameUtils.getDefaultJMXDomain(), hashtable);
        }
        catch (JMException jMException) {
            throw LoggedRuntimeException.newException("Failed to create ObjectName with parameter " + hashtable, jMException);
        }
    }

    @Nonnull
    public static ObjectName create(@Nonnull @Nonempty Map<String, String> map) {
        ValueEnforcer.notEmpty(map, "Params");
        return ObjectNameUtils.create(new Hashtable<String, String>(map));
    }

    @Nonnull
    public static String getCleanPropertyValue(@Nonnull String string) {
        if (string.indexOf(32) != -1) {
            return ObjectName.quote(string);
        }
        return string.replace(':', '.').replace(',', '.').replace("//", "__");
    }

    @Nonnull
    public static ObjectName createWithDefaultProperties(@Nonnull Object object) {
        ValueEnforcer.notNull(object, "Object");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("type", CGStringHelper.getClassLocalName(object));
        return ObjectNameUtils.create(hashtable);
    }

    @Nonnull
    public static ObjectName createWithDefaultProperties(@Nonnull Object object, @Nonnull String string) {
        ValueEnforcer.notNull(object, "Object");
        ValueEnforcer.notNull(string, "Name");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("type", CGStringHelper.getClassLocalName(object));
        hashtable.put("name", ObjectNameUtils.getCleanPropertyValue(string));
        return ObjectNameUtils.create(hashtable);
    }
}

