/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.messagedigest;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableObject;
import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.messagedigest.AbstractMessageDigestGenerator;
import com.helger.commons.messagedigest.EMessageDigestAlgorithm;
import com.helger.commons.messagedigest.IMessageDigestGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class NonBlockingMessageDigestGenerator
extends AbstractMessageDigestGenerator {
    private static final Logger s_aLogger = LoggerFactory.getLogger(NonBlockingMessageDigestGenerator.class);
    private final MessageDigest m_aMessageDigest;
    private byte[] m_aDigest;

    @Nonnull
    private static MessageDigest _createMD(@Nullable String string, EMessageDigestAlgorithm ... eMessageDigestAlgorithmArray) {
        MessageDigest messageDigest = null;
        for (EMessageDigestAlgorithm eMessageDigestAlgorithm : eMessageDigestAlgorithmArray) {
            try {
                if (string == null) {
                    messageDigest = MessageDigest.getInstance(eMessageDigestAlgorithm.getAlgorithm());
                    break;
                }
                messageDigest = MessageDigest.getInstance(eMessageDigestAlgorithm.getAlgorithm(), string);
                break;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                s_aLogger.warn("Unsupported message digest algorithm '" + eMessageDigestAlgorithm.getAlgorithm() + "' found");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new IllegalArgumentException("Unsupported security provider '" + string + "' found", noSuchProviderException);
            }
        }
        if (messageDigest == null) {
            throw new IllegalArgumentException("None of the algorithms in " + Arrays.toString((Object[])eMessageDigestAlgorithmArray) + " was applicable!");
        }
        return messageDigest;
    }

    public NonBlockingMessageDigestGenerator() {
        this(DEFAULT_ALGORITHM);
    }

    public NonBlockingMessageDigestGenerator(@Nullable String string) {
        this(string, DEFAULT_ALGORITHM);
    }

    public NonBlockingMessageDigestGenerator(EMessageDigestAlgorithm ... eMessageDigestAlgorithmArray) {
        this((String)null, eMessageDigestAlgorithmArray);
    }

    public NonBlockingMessageDigestGenerator(@Nullable String string, EMessageDigestAlgorithm ... eMessageDigestAlgorithmArray) {
        ValueEnforcer.notEmpty(eMessageDigestAlgorithmArray, "Algortihms");
        this.m_aMessageDigest = NonBlockingMessageDigestGenerator._createMD(string, eMessageDigestAlgorithmArray);
    }

    @Override
    @Nonnull
    public Provider getSecurityProvider() {
        return this.m_aMessageDigest.getProvider();
    }

    @Override
    @Nonnull
    public String getAlgorithmName() {
        return this.m_aMessageDigest.getAlgorithm();
    }

    @Override
    @Nonnegative
    public int getDigestLength() {
        return this.m_aMessageDigest.getDigestLength();
    }

    @Override
    @Nonnull
    public IMessageDigestGenerator update(byte by) {
        if (this.m_aDigest != null) {
            throw new IllegalStateException("The hash has already been finished. Call reset manually!");
        }
        this.m_aMessageDigest.update(by);
        return this;
    }

    @Override
    @Nonnull
    public IMessageDigestGenerator update(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        if (this.m_aDigest != null) {
            throw new IllegalStateException("The hash has already been finished. Call reset manually!");
        }
        this.m_aMessageDigest.update(byArray, n, n2);
        return this;
    }

    @Override
    public void reset() {
        this.m_aMessageDigest.reset();
        this.m_aDigest = null;
    }

    @Nonnull
    @ReturnsMutableObject(reason="design")
    private byte[] _getDigest() {
        if (this.m_aDigest == null) {
            this.m_aDigest = this.m_aMessageDigest.digest();
        }
        return this.m_aDigest;
    }

    @Override
    @Nonnull
    public byte[] getDigest() {
        return ArrayHelper.getCopy(this._getDigest());
    }

    @Override
    @Nonnull
    public byte[] getDigest(@Nonnegative int n) {
        return ArrayHelper.getCopy(this._getDigest(), 0, n);
    }

    public String toString() {
        return new ToStringGenerator(this).append("messageDigest", this.m_aMessageDigest).appendIfNotNull("digest", this.m_aDigest).toString();
    }
}

