/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom.impl;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.microdom.EMicroNodeType;
import com.helger.commons.microdom.IMicroCDATA;
import com.helger.commons.microdom.IMicroNode;
import com.helger.commons.microdom.impl.AbstractMicroNode;
import com.helger.commons.microdom.impl.MicroDataAware;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MicroCDATA
extends AbstractMicroNode
implements IMicroCDATA {
    private final MicroDataAware m_aData;

    public MicroCDATA(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this.m_aData = new MicroDataAware(cArray, n, n2);
    }

    public MicroCDATA(@Nullable CharSequence charSequence) {
        this.m_aData = new MicroDataAware(charSequence);
    }

    private MicroCDATA(@Nonnull MicroDataAware microDataAware) {
        this.m_aData = microDataAware.getClone();
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.CDATA;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeName() {
        return "#cdata-section";
    }

    @Override
    @Nonnull
    public String getNodeValue() {
        return this.getData().toString();
    }

    @Override
    @Nonnull
    public CharSequence getData() {
        return this.m_aData.getData();
    }

    @Override
    public void appendData(@Nullable CharSequence charSequence) {
        this.m_aData.appendData(charSequence);
    }

    @Override
    public void appendData(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this.m_aData.appendData(cArray, n, n2);
    }

    @Override
    public void appendData(char c) {
        this.m_aData.appendData(c);
    }

    @Override
    public void prependData(@Nullable CharSequence charSequence) {
        this.m_aData.prependData(charSequence);
    }

    @Override
    public void prependData(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this.m_aData.prependData(cArray, n, n2);
    }

    @Override
    public void prependData(char c) {
        this.m_aData.prependData(c);
    }

    @Override
    public void setData(@Nullable CharSequence charSequence) {
        this.m_aData.setData(charSequence);
    }

    @Override
    @Nonnull
    public IMicroCDATA getClone() {
        return new MicroCDATA(this.m_aData);
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (!(iMicroNode instanceof MicroCDATA)) {
            return false;
        }
        MicroCDATA microCDATA = (MicroCDATA)iMicroNode;
        return this.m_aData.equals(microCDATA.m_aData);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("text", this.getData()).toString();
    }
}

