/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.stats.utils;

import com.helger.commons.microdom.IMicroDocument;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.impl.MicroDocument;
import com.helger.commons.stats.utils.StatisticsVisitorToXML;
import com.helger.commons.stats.visit.StatisticsWalker;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StatisticsExporter {
    public static final String ELEMENT_STATISTICS = "statistics";
    public static final String ELEMENT_CACHE = "cache";
    public static final String ATTR_HITS = "hits";
    public static final String ATTR_MISSES = "misses";
    public static final String ELEMENT_TIMER = "timer";
    public static final String ELEMENT_KEYEDTIMER = "keyedtimer";
    public static final String ELEMENT_SIZE = "size";
    public static final String ELEMENT_KEYEDSIZE = "keyedsize";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_AVERAGE = "average";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_SUM = "sum";
    public static final String ELEMENT_COUNTER = "counter";
    public static final String ELEMENT_KEYEDCOUNTER = "keyedcounter";
    public static final String ELEMENT_KEY = "key";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_INVOCATIONCOUNT = "invocationcount";
    public static final String ATTR_COUNT = "count";
    private static final StatisticsExporter s_aInstance = new StatisticsExporter();

    private StatisticsExporter() {
    }

    @Nonnull
    public static IMicroDocument getAsXMLDocument() {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement(ELEMENT_STATISTICS);
        StatisticsWalker.walkStatistics(new StatisticsVisitorToXML(iMicroElement));
        return microDocument;
    }
}

