/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.impl;

import com.helger.commons.ValueEnforcer;
import java.text.MessageFormat;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TextFormatter {
    private static final TextFormatter s_aInstance = new TextFormatter();

    private TextFormatter() {
    }

    @Nullable
    public static String getFormattedText(@Nullable String string, Object ... objectArray) {
        if (string == null) {
            return null;
        }
        if (objectArray == null || objectArray.length == 0) {
            return string;
        }
        return MessageFormat.format(string, objectArray);
    }

    @Nullable
    public static String getFormattedText(@Nonnull Locale locale, @Nullable String string, Object ... objectArray) {
        ValueEnforcer.notNull(locale, "DisplayLocale");
        if (string == null) {
            return null;
        }
        if (objectArray == null || objectArray.length == 0) {
            return string;
        }
        MessageFormat messageFormat = new MessageFormat(string, locale);
        return messageFormat.format(objectArray);
    }
}

