/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.tree.utils.walk;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hierarchy.DefaultHierarchyWalkerCallback;
import com.helger.commons.hierarchy.IHierarchyWalkerCallback;
import com.helger.commons.parent.IChildrenProvider;
import com.helger.commons.parent.impl.ChildrenProviderHasChildren;
import com.helger.commons.tree.IBasicTree;
import com.helger.commons.tree.IBasicTreeItem;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeWalker {
    private static final TreeWalker s_aInstance = new TreeWalker();

    private TreeWalker() {
    }

    private static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void _walkTree(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull IChildrenProvider<ITEMTYPE> iChildrenProvider, @Nonnull IHierarchyWalkerCallback<? super ITEMTYPE> iHierarchyWalkerCallback) {
        iHierarchyWalkerCallback.onItemBeforeChildren(ITEMTYPE);
        if (iChildrenProvider.hasChildren(ITEMTYPE)) {
            for (IBasicTreeItem iBasicTreeItem : iChildrenProvider.getChildren(ITEMTYPE)) {
                iHierarchyWalkerCallback.onLevelDown();
                TreeWalker._walkTree(iBasicTreeItem, iChildrenProvider, iHierarchyWalkerCallback);
                iHierarchyWalkerCallback.onLevelUp();
            }
        }
        iHierarchyWalkerCallback.onItemAfterChildren(ITEMTYPE);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void walkTree(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull IHierarchyWalkerCallback<? super ITEMTYPE> iHierarchyWalkerCallback) {
        TreeWalker.walkTree(iBasicTree, new ChildrenProviderHasChildren(), iHierarchyWalkerCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void walkTree(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull IChildrenProvider<ITEMTYPE> iChildrenProvider, @Nonnull IHierarchyWalkerCallback<? super ITEMTYPE> iHierarchyWalkerCallback) {
        ValueEnforcer.notNull(iBasicTree, "Tree");
        TreeWalker.walkSubTree(iBasicTree.getRootItem(), iChildrenProvider, iHierarchyWalkerCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void walkTreeData(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull IHierarchyWalkerCallback<? super DATATYPE> iHierarchyWalkerCallback) {
        TreeWalker.walkTreeData(iBasicTree, new ChildrenProviderHasChildren(), iHierarchyWalkerCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void walkTreeData(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull IChildrenProvider<ITEMTYPE> iChildrenProvider, @Nonnull IHierarchyWalkerCallback<? super DATATYPE> iHierarchyWalkerCallback) {
        ValueEnforcer.notNull(iBasicTree, "Tree");
        TreeWalker.walkSubTreeData(iBasicTree.getRootItem(), iChildrenProvider, iHierarchyWalkerCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void walkSubTree(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull IHierarchyWalkerCallback<? super ITEMTYPE> iHierarchyWalkerCallback) {
        TreeWalker.walkSubTree(ITEMTYPE, new ChildrenProviderHasChildren(), iHierarchyWalkerCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void walkSubTree(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull IChildrenProvider<ITEMTYPE> iChildrenProvider, @Nonnull IHierarchyWalkerCallback<? super ITEMTYPE> iHierarchyWalkerCallback) {
        ValueEnforcer.notNull(ITEMTYPE, "TreeItem");
        ValueEnforcer.notNull(iChildrenProvider, "ChildrenProvider");
        ValueEnforcer.notNull(iHierarchyWalkerCallback, "Callback");
        iHierarchyWalkerCallback.begin();
        try {
            if (iChildrenProvider.hasChildren(ITEMTYPE)) {
                for (IBasicTreeItem iBasicTreeItem : iChildrenProvider.getChildren(ITEMTYPE)) {
                    TreeWalker._walkTree(iBasicTreeItem, iChildrenProvider, iHierarchyWalkerCallback);
                }
            }
        }
        finally {
            iHierarchyWalkerCallback.end();
        }
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void walkSubTreeData(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull IHierarchyWalkerCallback<? super DATATYPE> iHierarchyWalkerCallback) {
        TreeWalker.walkSubTreeData(ITEMTYPE, new ChildrenProviderHasChildren(), iHierarchyWalkerCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void walkSubTreeData(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull IChildrenProvider<ITEMTYPE> iChildrenProvider, final @Nonnull IHierarchyWalkerCallback<? super DATATYPE> iHierarchyWalkerCallback) {
        ValueEnforcer.notNull(iHierarchyWalkerCallback, "DataCallback");
        TreeWalker.walkSubTree(ITEMTYPE, iChildrenProvider, new DefaultHierarchyWalkerCallback<ITEMTYPE>(){

            @Override
            public void begin() {
                iHierarchyWalkerCallback.begin();
            }

            @Override
            public void onLevelDown() {
                super.onLevelDown();
                iHierarchyWalkerCallback.onLevelDown();
            }

            @Override
            public void onLevelUp() {
                super.onLevelUp();
                iHierarchyWalkerCallback.onLevelUp();
            }

            @Override
            public void end() {
                iHierarchyWalkerCallback.end();
            }

            @Override
            public void onItemBeforeChildren(@Nonnull ITEMTYPE ITEMTYPE) {
                iHierarchyWalkerCallback.onItemBeforeChildren(ITEMTYPE.getData());
            }

            @Override
            public void onItemAfterChildren(@Nonnull ITEMTYPE ITEMTYPE) {
                iHierarchyWalkerCallback.onItemAfterChildren(ITEMTYPE.getData());
            }
        });
    }
}

