/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.type;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.DevelopersNote;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@DevelopersNote(value="The mutable m_aHashCode does not contradict thread safety")
public class ObjectType
implements Comparable<ObjectType>,
Serializable {
    private final String m_sName;
    private Integer m_aHashCode;

    public ObjectType(@Nonnull @Nonempty String string) {
        this.m_sName = ValueEnforcer.notEmpty(string, "Name");
    }

    @Nonnull
    @Nonempty
    public String getObjectTypeName() {
        return this.m_sName;
    }

    @Override
    public int compareTo(@Nonnull ObjectType objectType) {
        return this.m_sName.compareTo(objectType.m_sName);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectType)) {
            return false;
        }
        ObjectType objectType = (ObjectType)object;
        return this.m_sName.equals(objectType.m_sName);
    }

    public int hashCode() {
        if (this.m_aHashCode == null) {
            this.m_aHashCode = new HashCodeGenerator(this).append(this.m_sName).getHashCodeObj();
        }
        return this.m_aHashCode;
    }

    public String toString() {
        return new ToStringGenerator(this).append("name", this.m_sName).toString();
    }
}

