/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.url;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.annotations.ReturnsMutableObject;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.IURLData;
import com.helger.commons.url.IURLProtocol;
import com.helger.commons.url.URLProtocolRegistry;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class URLData
implements IURLData {
    public static final URLData EMPTY_URL_DATA = new URLData("?");
    private final String m_sPath;
    private final Map<String, String> m_aParams;
    private final String m_sAnchor;

    public URLData(@Nonnull String string) {
        this(string, null, null);
    }

    public URLData(@Nonnull String string, @Nullable Map<String, String> map) {
        this(string, map, null);
    }

    public URLData(@Nonnull String string, @Nullable Map<String, String> map, @Nullable String string2) {
        this.m_sPath = ValueEnforcer.notNull(string, "Path");
        this.m_aParams = map;
        this.m_sAnchor = string2;
    }

    @Override
    @Nullable
    public IURLProtocol getProtocol() {
        return URLProtocolRegistry.getInstance().getProtocol(this.m_sPath);
    }

    @Override
    public boolean hasKnownProtocol() {
        return URLProtocolRegistry.getInstance().hasKnownProtocol(this.m_sPath);
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.m_sPath;
    }

    @Override
    public boolean hasParams() {
        return ContainerHelper.isNotEmpty(this.m_aParams);
    }

    @Override
    @Nonnegative
    public int getParamCount() {
        return ContainerHelper.getSize(this.m_aParams);
    }

    @Override
    @Nullable
    @ReturnsMutableObject(reason="Performance reasons")
    public Map<String, String> directGetParams() {
        return this.m_aParams;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllParams() {
        return ContainerHelper.newOrderedMap(this.m_aParams);
    }

    @Override
    public boolean hasAnchor() {
        return StringHelper.hasText(this.m_sAnchor);
    }

    @Override
    @Nullable
    public String getAnchor() {
        return this.m_sAnchor;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof URLData)) {
            return false;
        }
        URLData uRLData = (URLData)object;
        return this.m_sPath.equals(uRLData.m_sPath) && EqualsUtils.equals(this.m_aParams, uRLData.m_aParams) && EqualsUtils.equals(this.m_sAnchor, uRLData.m_sAnchor);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sPath).append((Map)this.m_aParams)).append(this.m_sAnchor).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("path", this.m_sPath).appendIfNotNull("params", this.m_aParams).appendIfNotNull("anchor", this.m_sAnchor).toString();
    }
}

