/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.ls;

import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.xml.ls.LSResourceData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

@ThreadSafe
public class CollectingLSResourceResolver
implements LSResourceResolver {
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final List<LSResourceData> m_aList = new ArrayList<LSResourceData>();
    private final LSResourceResolver m_aWrappedResourceResolver;

    public CollectingLSResourceResolver() {
        this(null);
    }

    public CollectingLSResourceResolver(@Nullable LSResourceResolver lSResourceResolver) {
        this.m_aWrappedResourceResolver = lSResourceResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public List<LSResourceData> getAllRequestedResources() {
        this.m_aRWLock.readLock().lock();
        try {
            List<LSResourceData> list = ContainerHelper.newList(this.m_aList);
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LSInput resolveResource(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5) {
        LSResourceData lSResourceData = new LSResourceData(string, string2, string3, string4, string5);
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aList.add(lSResourceData);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        return this.m_aWrappedResourceResolver == null ? null : this.m_aWrappedResourceResolver.resolveResource(string, string2, string3, string4, string5);
    }
}

