/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.serialize;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.io.streams.NonBlockingBufferedWriter;
import com.helger.commons.io.streams.StreamUtils;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.IXMLIterationHandler;
import com.helger.commons.xml.XMLHelper;
import com.helger.commons.xml.namespace.IIterableNamespaceContext;
import com.helger.commons.xml.serialize.IXMLSerializer;
import com.helger.commons.xml.serialize.IXMLWriterSettings;
import com.helger.commons.xml.serialize.XMLEmitter;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXMLSerializer<NODETYPE>
implements IXMLSerializer<NODETYPE> {
    public static final String DEFAULT_NAMESPACE_PREFIX_PREFIX = "ns";
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractXMLSerializer.class);
    protected final IXMLWriterSettings m_aSettings;
    protected final StringBuilder m_aIndent = new StringBuilder(32);
    protected final NamespaceStack m_aNSStack;

    public AbstractXMLSerializer(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        this.m_aSettings = ValueEnforcer.notNull(iXMLWriterSettings, "Settings");
        this.m_aNSStack = new NamespaceStack(iXMLWriterSettings.getNamespaceContext());
    }

    @Nonnull
    public final IXMLWriterSettings getSettings() {
        return this.m_aSettings;
    }

    protected final void handlePutNamespaceContextPrefixInRoot(@Nonnull Map<String, String> map) {
        NamespaceContext namespaceContext;
        if (this.m_aNSStack.size() == 1 && this.m_aSettings.isPutNamespaceContextPrefixesInRoot() && this.m_aSettings.isEmitNamespaces() && (namespaceContext = this.m_aSettings.getNamespaceContext()) != null) {
            if (namespaceContext instanceof IIterableNamespaceContext) {
                for (Map.Entry<String, String> entry : ((IIterableNamespaceContext)namespaceContext).getPrefixToNamespaceURIMap().entrySet()) {
                    String string = entry.getKey();
                    String string2 = entry.getValue();
                    map.put(XMLHelper.getXMLNSAttrName(string), string2);
                    this.m_aNSStack.addNamespaceMapping(string, string2);
                }
            } else {
                s_aLogger.error("XMLWriter settings has putNamespaceContextPrefixesInRoot set, but the NamespaceContext does not implement the IIterableNamespaceContext interface!");
            }
        }
    }

    protected abstract void emitNode(@Nonnull IXMLIterationHandler var1, @Nullable NODETYPE var2, @Nonnull NODETYPE var3, @Nullable NODETYPE var4);

    @Nonnull
    @OverrideOnDemand
    protected XMLEmitter createXMLEmitter(@Nonnull @WillNotClose Writer writer, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        return new XMLEmitter(writer, iXMLWriterSettings);
    }

    @Override
    public final void write(@Nonnull NODETYPE NODETYPE, @Nonnull @WillNotClose Writer writer) {
        XMLEmitter xMLEmitter = this.createXMLEmitter(writer, this.m_aSettings);
        this.emitNode(xMLEmitter, null, NODETYPE, null);
        StreamUtils.flush(writer);
    }

    public final void write(@Nonnull NODETYPE NODETYPE, @Nonnull IXMLIterationHandler iXMLIterationHandler) {
        this.emitNode(iXMLIterationHandler, null, NODETYPE, null);
    }

    @Override
    public final void write(@Nonnull NODETYPE NODETYPE, @Nonnull @WillNotClose OutputStream outputStream) {
        ValueEnforcer.notNull(NODETYPE, "Node");
        ValueEnforcer.notNull(outputStream, "OutputStream");
        NonBlockingBufferedWriter nonBlockingBufferedWriter = new NonBlockingBufferedWriter(StreamUtils.createWriter(outputStream, this.m_aSettings.getCharsetObj()));
        this.write(NODETYPE, nonBlockingBufferedWriter);
    }

    public String toString() {
        return new ToStringGenerator(this).append("settings", this.m_aSettings).append("sIndent", this.m_aIndent.toString()).append("namespaceStack", this.m_aNSStack).toString();
    }

    protected static final class NamespaceStack {
        private final List<NamespaceLevel> m_aStack = new ArrayList<NamespaceLevel>();
        private final NamespaceContext m_aNamespaceCtx;

        public NamespaceStack(@Nullable NamespaceContext namespaceContext) {
            this.m_aNamespaceCtx = namespaceContext;
        }

        public void push(@Nullable Map<String, String> map) {
            NamespaceLevel namespaceLevel = new NamespaceLevel(map);
            this.m_aStack.add(0, namespaceLevel);
        }

        public void addNamespaceMapping(@Nullable String string, @Nonnull @Nonempty String string2) {
            this.m_aStack.get(0).addPrefixNamespaceMapping(string, string2);
        }

        public void pop() {
            this.m_aStack.remove(0);
        }

        @Nonnegative
        public int size() {
            return this.m_aStack.size();
        }

        @Nullable
        public String getDefaultNamespaceURI() {
            for (NamespaceLevel namespaceLevel : this.m_aStack) {
                String string = namespaceLevel.getDefaultNamespaceURI();
                if (!StringHelper.hasText(string)) continue;
                return string;
            }
            return null;
        }

        @Nullable
        public String getUsedPrefixOfNamespace(@Nonnull String string) {
            ValueEnforcer.notNull(string, "NamespaceURI");
            for (NamespaceLevel namespaceLevel : this.m_aStack) {
                String string2 = namespaceLevel.getPrefixOfNamespaceURI(string);
                if (string2 == null) continue;
                return string2;
            }
            return null;
        }

        private boolean _containsNoNamespace() {
            for (NamespaceLevel namespaceLevel : this.m_aStack) {
                if (!namespaceLevel.hasAnyNamespace()) continue;
                return false;
            }
            return true;
        }

        private boolean _containsNoPrefix(@Nonnull String string) {
            for (NamespaceLevel namespaceLevel : this.m_aStack) {
                if (namespaceLevel.getNamespaceURIOfPrefix(string) == null) continue;
                return false;
            }
            return true;
        }

        @Nullable
        public String getMappedPrefix(@Nonnull String string) {
            String string2;
            ValueEnforcer.notNull(string, "NamespaceURI");
            if (this.m_aNamespaceCtx != null && (string2 = this.m_aNamespaceCtx.getPrefix(string)) != null) {
                return string2;
            }
            return null;
        }

        @Nullable
        public String createUniquePrefix() {
            if (this._containsNoNamespace()) {
                return null;
            }
            int n = 0;
            String string;
            while (!this._containsNoPrefix(string = AbstractXMLSerializer.DEFAULT_NAMESPACE_PREFIX_PREFIX + n)) {
                ++n;
            }
            return string;
        }
    }

    protected static final class NamespaceLevel {
        private static final Logger s_aLogger = LoggerFactory.getLogger(NamespaceLevel.class);
        private String m_sDefaultNamespaceURI;
        private Map<String, String> m_aURL2PrefixMap;

        public NamespaceLevel(@Nullable Map<String, String> map) {
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string;
                    String string2 = entry.getKey();
                    if (string2.equals("xmlns")) {
                        string = entry.getValue();
                        this.addPrefixNamespaceMapping(null, string);
                        if (!s_aLogger.isDebugEnabled()) continue;
                        s_aLogger.debug("Found default namespace '" + string + "' in attribute!");
                        continue;
                    }
                    if (!string2.startsWith("xmlns:")) continue;
                    string = string2.substring("xmlns:".length());
                    String string3 = entry.getValue();
                    this.addPrefixNamespaceMapping(string, string3);
                    if (!s_aLogger.isDebugEnabled()) continue;
                    s_aLogger.debug("Found namespace prefix '" + string + "' (with URL '" + string3 + "') in attribute!");
                }
            }
        }

        @Nullable
        public String getNamespaceURIOfPrefix(@Nullable String string) {
            if (StringHelper.hasNoText(string)) {
                return this.m_sDefaultNamespaceURI;
            }
            if (this.m_aURL2PrefixMap != null) {
                for (Map.Entry<String, String> entry : this.m_aURL2PrefixMap.entrySet()) {
                    if (!entry.getValue().equals(string)) continue;
                    return entry.getKey();
                }
            }
            return null;
        }

        void addPrefixNamespaceMapping(@Nullable String string, @Nonnull @Nonempty String string2) {
            String string3;
            if (s_aLogger.isTraceEnabled()) {
                s_aLogger.trace("Adding namespace mapping " + string + ":" + string2);
            }
            if ((string3 = this.getNamespaceURIOfPrefix(string)) != null && !string3.equals(string2)) {
                s_aLogger.warn("Overwriting namespace prefix '" + string + "' to use URL '" + string2 + "' instead of '" + string3 + "'");
            }
            if (StringHelper.hasNoText(string)) {
                if (this.m_sDefaultNamespaceURI != null) {
                    s_aLogger.warn("Overwriting default namespace '" + this.m_sDefaultNamespaceURI + "' with namespace '" + string2 + "'");
                }
                this.m_sDefaultNamespaceURI = string2;
            } else {
                if (this.m_aURL2PrefixMap == null) {
                    this.m_aURL2PrefixMap = new HashMap<String, String>();
                }
                this.m_aURL2PrefixMap.put(string2, string);
            }
        }

        @Nullable
        public String getDefaultNamespaceURI() {
            return this.m_sDefaultNamespaceURI;
        }

        @Nullable
        public String getPrefixOfNamespaceURI(@Nonnull String string) {
            if (string.equals(this.m_sDefaultNamespaceURI)) {
                return null;
            }
            return this.m_aURL2PrefixMap == null ? null : this.m_aURL2PrefixMap.get(string);
        }

        @Nonnegative
        int getNamespaceCount() {
            return (this.m_sDefaultNamespaceURI == null ? 0 : 1) + (this.m_aURL2PrefixMap == null ? 0 : this.m_aURL2PrefixMap.size());
        }

        boolean hasAnyNamespace() {
            return this.m_sDefaultNamespaceURI != null || this.m_aURL2PrefixMap != null && !this.m_aURL2PrefixMap.isEmpty();
        }

        public String toString() {
            return new ToStringGenerator(this).append("defaultNSURI", this.m_sDefaultNamespaceURI).append("url2prefix", this.m_aURL2PrefixMap).toString();
        }
    }
}

