/**
 * Copyright (C) 2014 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.commons.hierarchy;

import javax.annotation.Nonnull;

import com.helger.commons.annotations.OverrideOnDemand;

/**
 * The default implementation of the {@link IHierarchyWalkerDynamicCallback}
 * interface doing nothing.
 * 
 * @author Philip Helger
 * @param <DATATYPE>
 *        The type of object in the hierarchy to be iterated
 */
public class DefaultHierarchyWalkerDynamicCallback <DATATYPE> extends DefaultHierarchyWalker implements
                                                                                            IHierarchyWalkerDynamicCallback <DATATYPE>
{
  public DefaultHierarchyWalkerDynamicCallback ()
  {
    super ();
  }

  public DefaultHierarchyWalkerDynamicCallback (final int nInitialLevel)
  {
    super (nInitialLevel);
  }

  @OverrideOnDemand
  @Nonnull
  public EHierarchyCallbackReturn onItemBeforeChildren (final DATATYPE aItem)
  {
    return EHierarchyCallbackReturn.CONTINUE;
  }

  @OverrideOnDemand
  @Nonnull
  public EHierarchyCallbackReturn onItemAfterChildren (final DATATYPE aItem)
  {
    return EHierarchyCallbackReturn.CONTINUE;
  }
}
