/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.cache;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.collections.LRUCache;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class LoggingLRUCache<KEYTYPE, VALUETYPE>
extends LRUCache<KEYTYPE, VALUETYPE> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LoggingLRUCache.class);
    private final String m_sCacheName;

    public LoggingLRUCache(@Nonnull @Nonempty String string, @Nonnegative int n) {
        super(n);
        this.m_sCacheName = ValueEnforcer.notEmpty(string, "CacheName");
    }

    @Nonnull
    @Nonempty
    public String getCacheName() {
        return this.m_sCacheName;
    }

    @Override
    protected void onRemoveEldestEntry(@Nonnull Map.Entry<KEYTYPE, VALUETYPE> entry) {
        s_aLogger.warn("Cache '" + this.m_sCacheName + "' is full with " + this.getMaxSize() + " items! Removed " + entry.getKey() + "//" + entry.getValue());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        LoggingLRUCache loggingLRUCache = (LoggingLRUCache)object;
        return this.m_sCacheName.equals(loggingLRUCache.m_sCacheName);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_sCacheName).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("cacheName", this.m_sCacheName).toString();
    }
}

