/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.base64.Base64;
import com.helger.commons.base64.Base64Helper;
import com.helger.commons.charset.CCharset;
import com.helger.commons.codec.AbstractRFC1522Codec;
import com.helger.commons.codec.DecoderException;
import com.helger.commons.codec.EncoderException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RFC1522BCodec
extends AbstractRFC1522Codec {
    private final Charset m_aCharset;

    public RFC1522BCodec() {
        this(CCharset.CHARSET_UTF_8_OBJ);
    }

    public RFC1522BCodec(@Nonnull Charset charset) {
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
    }

    @Override
    protected String getRFC1522Encoding() {
        return "B";
    }

    @Override
    @Nonnull
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    @Nullable
    public byte[] encode(@Nullable byte[] byArray) {
        return byArray == null ? null : Base64.encodeBytesToBytes(byArray);
    }

    @Override
    @Nullable
    public byte[] decode(@Nullable byte[] byArray) {
        return byArray == null ? null : Base64Helper.safeDecode(byArray);
    }

    @Override
    @Nullable
    public String encodeText(@Nullable String string) throws EncoderException {
        return super.encodeText(string, this.getCharset());
    }

    @Override
    @Nullable
    public String decodeText(@Nullable String string) throws DecoderException {
        return super.decodeText(string);
    }
}

