/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.flags;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.collections.flags.IFlagContainer;
import com.helger.commons.collections.flags.IReadonlyFlagContainer;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FlagContainer
implements IFlagContainer {
    private final Set<String> m_aFlags = new HashSet<String>();

    public FlagContainer() {
    }

    public FlagContainer(@Nonnull Collection<String> collection) {
        ValueEnforcer.notNull(collection, "Values");
        this.m_aFlags.addAll(collection);
    }

    public FlagContainer(String ... stringArray) {
        ValueEnforcer.notNull(stringArray, "Values");
        Collections.addAll(this.m_aFlags, stringArray);
    }

    public FlagContainer(@Nonnull IReadonlyFlagContainer iReadonlyFlagContainer) {
        ValueEnforcer.notNull(iReadonlyFlagContainer, "Cont");
        this.m_aFlags.addAll(iReadonlyFlagContainer.getAllFlags());
    }

    @Override
    public boolean containsFlag(@Nullable String string) {
        return string != null && this.m_aFlags.contains(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllFlags() {
        return ContainerHelper.newSet(this.m_aFlags);
    }

    @Override
    @Nonnull
    public EChange addFlag(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Name");
        return EChange.valueOf(this.m_aFlags.add(string));
    }

    @Override
    @Nonnull
    public final EChange addFlags(@Nullable Collection<String> collection) {
        EChange eChange = EChange.UNCHANGED;
        if (collection != null) {
            for (String string : collection) {
                eChange = eChange.or(this.addFlag(string));
            }
        }
        return eChange;
    }

    @Override
    @Nonnull
    public final EChange addFlags(String ... stringArray) {
        EChange eChange = EChange.UNCHANGED;
        if (stringArray != null) {
            for (String string : stringArray) {
                eChange = eChange.or(this.addFlag(string));
            }
        }
        return eChange;
    }

    @Override
    @Nonnull
    public EChange removeFlag(@Nullable String string) {
        return EChange.valueOf(string != null && this.m_aFlags.remove(string));
    }

    @Override
    @Nonnegative
    public int getFlagCount() {
        return this.m_aFlags.size();
    }

    @Override
    public boolean containsNoFlag() {
        return this.m_aFlags.isEmpty();
    }

    @Override
    @Nonnull
    public EChange clear() {
        if (this.m_aFlags.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aFlags.clear();
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FlagContainer flagContainer = (FlagContainer)object;
        return this.m_aFlags.equals(flagContainer.m_aFlags);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aFlags)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("flags", this.m_aFlags).toString();
    }
}

