/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.flags;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.collections.flags.IReadonlyFlagContainer;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ReadonlyFlagContainer
implements IReadonlyFlagContainer {
    private final Set<String> m_aFlags;

    public ReadonlyFlagContainer(@Nonnull Collection<String> collection) {
        ValueEnforcer.notNull(collection, "Values");
        this.m_aFlags = ContainerHelper.newSet(collection);
    }

    public ReadonlyFlagContainer(String ... stringArray) {
        ValueEnforcer.notNull(stringArray, "Values");
        this.m_aFlags = ContainerHelper.newSet(stringArray);
    }

    public ReadonlyFlagContainer(@Nonnull IReadonlyFlagContainer iReadonlyFlagContainer) {
        ValueEnforcer.notNull(iReadonlyFlagContainer, "Cont");
        this.m_aFlags = iReadonlyFlagContainer.getAllFlags();
    }

    @Override
    public boolean containsFlag(@Nullable String string) {
        return this.m_aFlags.contains(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllFlags() {
        return ContainerHelper.newSet(this.m_aFlags);
    }

    @Override
    @Nonnegative
    public int getFlagCount() {
        return this.m_aFlags.size();
    }

    @Override
    public boolean containsNoFlag() {
        return this.m_aFlags.isEmpty();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ReadonlyFlagContainer readonlyFlagContainer = (ReadonlyFlagContainer)object;
        return this.m_aFlags.equals(readonlyFlagContainer.m_aFlags);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aFlags)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("flags", this.m_aFlags).toString();
    }
}

