/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.list;

import com.helger.commons.IHasSize;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractWrappedList<ELEMENTTYPE>
implements List<ELEMENTTYPE>,
IHasSize {
    private final List<ELEMENTTYPE> m_aSrc;

    public AbstractWrappedList(@Nonnull List<ELEMENTTYPE> list) {
        this.m_aSrc = ValueEnforcer.notNull(list, "List");
    }

    @Nonnull
    @ReturnsMutableObject(reason="design")
    protected List<ELEMENTTYPE> getSrcList() {
        return this.m_aSrc;
    }

    @Override
    @Nullable
    public ELEMENTTYPE get(@Nonnegative int n) {
        return this.m_aSrc.get(n);
    }

    @Override
    public boolean add(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return this.m_aSrc.add(ELEMENTTYPE);
    }

    @Override
    public void add(@Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        this.m_aSrc.add(n, ELEMENTTYPE);
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends ELEMENTTYPE> collection) {
        return this.m_aSrc.addAll(collection);
    }

    @Override
    public boolean addAll(@Nonnegative int n, @Nonnull Collection<? extends ELEMENTTYPE> collection) {
        return this.m_aSrc.addAll(n, collection);
    }

    @Override
    public void clear() {
        this.m_aSrc.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.m_aSrc.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.m_aSrc.containsAll(collection);
    }

    @Override
    public int indexOf(Object object) {
        return this.m_aSrc.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.m_aSrc.isEmpty();
    }

    @Override
    public Iterator<ELEMENTTYPE> iterator() {
        return this.m_aSrc.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.m_aSrc.lastIndexOf(object);
    }

    @Override
    public ListIterator<ELEMENTTYPE> listIterator() {
        return this.m_aSrc.listIterator();
    }

    @Override
    public ListIterator<ELEMENTTYPE> listIterator(int n) {
        return this.m_aSrc.listIterator(n);
    }

    @Override
    public boolean remove(Object object) {
        return this.m_aSrc.remove(object);
    }

    @Override
    public ELEMENTTYPE remove(int n) {
        return this.m_aSrc.remove(n);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.m_aSrc.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.m_aSrc.retainAll(collection);
    }

    @Override
    public ELEMENTTYPE set(@Nonnegative int n, ELEMENTTYPE ELEMENTTYPE) {
        return this.m_aSrc.set(n, ELEMENTTYPE);
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aSrc.size();
    }

    @Override
    public List<ELEMENTTYPE> subList(int n, int n2) {
        return this.m_aSrc.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.m_aSrc.toArray();
    }

    @Override
    public <ARRAYELEMENTTYPE> ARRAYELEMENTTYPE[] toArray(ARRAYELEMENTTYPE[] ARRAYELEMENTTYPEArray) {
        return this.m_aSrc.toArray(ARRAYELEMENTTYPEArray);
    }

    @Override
    public boolean equals(Object object) {
        return this.m_aSrc.equals(object);
    }

    @Override
    public int hashCode() {
        return this.m_aSrc.hashCode();
    }

    public String toString() {
        return this.m_aSrc.toString();
    }
}

