/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.filter.collections;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collections.iterate.IIterableIterator;
import com.helger.commons.filter.IFilter;
import com.helger.commons.string.ToStringGenerator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public final class FilterIterator<ELEMENTTYPE>
implements IIterableIterator<ELEMENTTYPE> {
    private final Iterator<? extends ELEMENTTYPE> m_aBaseIter;
    @SuppressFBWarnings(value={"UWF_NULL_FIELD"})
    private ELEMENTTYPE m_aCurrent;
    private final IFilter<ELEMENTTYPE> m_aFilter;

    public FilterIterator(@Nonnull IIterableIterator<? extends ELEMENTTYPE> iIterableIterator, @Nonnull IFilter<ELEMENTTYPE> iFilter) {
        this(iIterableIterator.iterator(), iFilter);
    }

    public FilterIterator(@Nonnull Iterator<? extends ELEMENTTYPE> iterator, @Nonnull IFilter<ELEMENTTYPE> iFilter) {
        this.m_aBaseIter = ValueEnforcer.notNull(iterator, "BaseIterator");
        this.m_aFilter = ValueEnforcer.notNull(iFilter, "Filter");
        this._gotoNextCurrent();
    }

    public FilterIterator(@Nonnull Iterable<? extends ELEMENTTYPE> iterable, @Nonnull IFilter<ELEMENTTYPE> iFilter) {
        ValueEnforcer.notNull(iterable, "BaseContainer");
        this.m_aBaseIter = iterable.iterator();
        this.m_aFilter = ValueEnforcer.notNull(iFilter, "Filter");
        this._gotoNextCurrent();
    }

    @Nonnull
    public IFilter<ELEMENTTYPE> getFilter() {
        return this.m_aFilter;
    }

    private void _gotoNextCurrent() {
        this.m_aCurrent = null;
        while (this.m_aBaseIter.hasNext()) {
            ELEMENTTYPE ELEMENTTYPE = this.m_aBaseIter.next();
            if (!this.m_aFilter.matchesFilter(ELEMENTTYPE)) continue;
            this.m_aCurrent = ELEMENTTYPE;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        return this.m_aCurrent != null;
    }

    @Override
    public ELEMENTTYPE next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ELEMENTTYPE ELEMENTTYPE = this.m_aCurrent;
        this._gotoNextCurrent();
        return ELEMENTTYPE;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Iterator<ELEMENTTYPE> iterator() {
        return this;
    }

    public String toString() {
        return new ToStringGenerator(this).append("baseIter", this.m_aBaseIter).append("filter", this.m_aFilter).toString();
    }
}

