/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.i18n;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.i18n.AbstractCodepointIterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CodepointIteratorCharSequence
extends AbstractCodepointIterator {
    private final CharSequence m_aBuffer;

    public CodepointIteratorCharSequence(@Nonnull CharSequence charSequence) {
        this(charSequence, 0, charSequence.length());
    }

    public CodepointIteratorCharSequence(@Nonnull CharSequence charSequence, @Nonnegative int n, @Nonnegative int n2) {
        this.m_aBuffer = ValueEnforcer.notNull(charSequence, "Buffer");
        this.m_nPosition = ValueEnforcer.isGE0(n, "Offset");
        this.m_nLimit = Math.min(charSequence.length() - n, n2);
    }

    @Override
    protected char get() {
        return this.m_aBuffer.charAt(this.m_nPosition++);
    }

    @Override
    protected char get(int n) {
        return this.m_aBuffer.charAt(n);
    }
}

