/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.idfactory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.idfactory.GlobalIDFactory;
import com.helger.commons.idfactory.IStringIDFactory;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;

public class StringIDFromGlobalLongIDFactory
implements IStringIDFactory {
    private final String m_sPrefix;

    public StringIDFromGlobalLongIDFactory() {
        this("id");
    }

    public StringIDFromGlobalLongIDFactory(@Nonnull String string) {
        this.m_sPrefix = ValueEnforcer.notNull(string, "Prefix");
    }

    @Nonnull
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Override
    @Nonnull
    public String getNewID() {
        return this.m_sPrefix + Long.toString(GlobalIDFactory.getNewLongID());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        StringIDFromGlobalLongIDFactory stringIDFromGlobalLongIDFactory = (StringIDFromGlobalLongIDFactory)object;
        return this.m_sPrefix.equals(stringIDFromGlobalLongIDFactory.m_sPrefix);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPrefix).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("prefix", this.m_sPrefix).toString();
    }
}

