/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.tree.utils.sort;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hierarchy.DefaultHierarchyWalkerCallback;
import com.helger.commons.tree.IBasicTree;
import com.helger.commons.tree.simple.ITreeItem;
import com.helger.commons.tree.utils.sort.ComparatorTreeItemData;
import com.helger.commons.tree.utils.sort.ComparatorTreeItemDataComparable;
import com.helger.commons.tree.utils.walk.TreeWalker;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeSorter {
    private static final TreeSorter s_aInstance = new TreeSorter();

    private TreeSorter() {
    }

    private static <DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> void _sort(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, final @Nonnull Comparator<? super ITEMTYPE> comparator) {
        ValueEnforcer.notNull(iBasicTree, "Tree");
        ValueEnforcer.notNull(comparator, "Comparator");
        ((ITreeItem)iBasicTree.getRootItem()).reorderChildItems(comparator);
        TreeWalker.walkTree(iBasicTree, new DefaultHierarchyWalkerCallback<ITEMTYPE>(){

            @Override
            public void onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    ITEMTYPE.reorderChildItems(comparator);
                }
            }
        });
    }

    public static <DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> void sort(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull Comparator<? super DATATYPE> comparator) {
        ComparatorTreeItemData comparatorTreeItemData = new ComparatorTreeItemData(comparator);
        TreeSorter._sort(iBasicTree, comparatorTreeItemData);
    }

    public static <DATATYPE extends Comparable<? super DATATYPE>, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> void sort(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree) {
        ComparatorTreeItemDataComparable comparatorTreeItemDataComparable = new ComparatorTreeItemDataComparable();
        TreeSorter._sort(iBasicTree, comparatorTreeItemDataComparable);
    }
}

