/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.tree.withid;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.tree.withid.ITreeItemWithID;
import com.helger.commons.tree.withid.ITreeItemWithIDFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BasicTreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>>
implements ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE> {
    private final ITreeItemWithIDFactory<KEYTYPE, DATATYPE, ITEMTYPE> m_aFactory;
    private ITEMTYPE m_aParent;
    private final KEYTYPE m_aDataID;
    private DATATYPE m_aData;
    private Map<KEYTYPE, ITEMTYPE> m_aChildMap = null;
    private List<ITEMTYPE> m_aChildren = null;

    public BasicTreeItemWithID(@Nonnull ITreeItemWithIDFactory<KEYTYPE, DATATYPE, ITEMTYPE> iTreeItemWithIDFactory) {
        this(iTreeItemWithIDFactory, (null));
    }

    public BasicTreeItemWithID(@Nonnull ITreeItemWithIDFactory<KEYTYPE, DATATYPE, ITEMTYPE> iTreeItemWithIDFactory, @Nullable KEYTYPE KEYTYPE) {
        this.m_aFactory = ValueEnforcer.notNull(iTreeItemWithIDFactory, "Factory");
        this.m_aDataID = KEYTYPE;
    }

    public BasicTreeItemWithID(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull KEYTYPE KEYTYPE) {
        ValueEnforcer.notNull(ITEMTYPE, "Parent");
        if (!(ITEMTYPE instanceof BasicTreeItemWithID)) {
            throw new IllegalArgumentException("Parent is no BasicTreeItemWithID");
        }
        if (ITEMTYPE.getFactory() == null) {
            throw new IllegalStateException("Parent item has no factory!");
        }
        ValueEnforcer.notNull(KEYTYPE, "DataID");
        this.m_aParent = ITEMTYPE;
        this.m_aFactory = this.m_aParent.getFactory();
        this.m_aDataID = KEYTYPE;
    }

    @Override
    @Nonnull
    public final ITreeItemWithIDFactory<KEYTYPE, DATATYPE, ITEMTYPE> getFactory() {
        return this.m_aFactory;
    }

    @OverrideOnDemand
    protected boolean isValidDataID(KEYTYPE KEYTYPE) {
        return true;
    }

    @OverrideOnDemand
    protected boolean isValidData(DATATYPE DATATYPE) {
        return true;
    }

    @Override
    public final boolean isRootItem() {
        return this.m_aParent == null;
    }

    @Nonnull
    private ITEMTYPE _asT(@Nonnull BasicTreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE> basicTreeItemWithID) {
        return (ITEMTYPE)((ITreeItemWithID)GenericReflection.uncheckedCast(basicTreeItemWithID));
    }

    @Override
    @Nullable
    public final ITEMTYPE getParent() {
        return this.m_aParent;
    }

    @Override
    @Nullable
    public final KEYTYPE getParentID() {
        return this.m_aParent == null ? null : (KEYTYPE)this.m_aParent.getID();
    }

    @Override
    @Nullable
    public final DATATYPE getParentData() {
        return this.m_aParent == null ? null : (DATATYPE)this.m_aParent.getData();
    }

    @Override
    @Nullable
    public final KEYTYPE getID() {
        return this.m_aDataID;
    }

    @Override
    @Nullable
    public final DATATYPE getData() {
        return this.m_aData;
    }

    @Override
    public final boolean hasChildren() {
        return this.m_aChildMap != null && !this.m_aChildMap.isEmpty();
    }

    @Override
    @Nonnegative
    public final int getChildCount() {
        return this.m_aChildMap == null ? 0 : this.m_aChildMap.size();
    }

    @Override
    @Nullable
    @Deprecated
    @ReturnsMutableCopy
    public final List<ITEMTYPE> getChildren() {
        return this.getAllChildren();
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public final List<ITEMTYPE> getAllChildren() {
        return this.m_aChildren == null ? null : ContainerHelper.newList(this.m_aChildren);
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public final Set<KEYTYPE> getAllChildDataIDs() {
        if (this.m_aChildMap == null) {
            return null;
        }
        return ContainerHelper.newSet(this.m_aChildMap.keySet());
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public final List<DATATYPE> getAllChildDatas() {
        if (this.m_aChildren == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (ITreeItemWithID iTreeItemWithID : this.m_aChildren) {
            arrayList.add(iTreeItemWithID.getData());
        }
        return arrayList;
    }

    @Override
    @Nullable
    public final ITEMTYPE getChildAtIndex(@Nonnegative int n) {
        if (this.m_aChildren == null) {
            throw new IndexOutOfBoundsException("Tree item has no children!");
        }
        return (ITEMTYPE)((ITreeItemWithID)this.m_aChildren.get(n));
    }

    @Override
    @Nullable
    public ITEMTYPE getFirstChild() {
        return (ITEMTYPE)((ITreeItemWithID)ContainerHelper.getFirstElement(this.m_aChildren));
    }

    @Override
    @Nullable
    public ITEMTYPE getLastChild() {
        return (ITEMTYPE)((ITreeItemWithID)ContainerHelper.getLastElement(this.m_aChildren));
    }

    @Override
    public final void setData(@Nullable DATATYPE DATATYPE) {
        if (!this.isValidData(DATATYPE)) {
            throw new IllegalArgumentException("The passed data object is invalid!");
        }
        this.m_aData = DATATYPE;
    }

    @Override
    @Nullable
    public final ITEMTYPE createChildItem(@Nullable KEYTYPE KEYTYPE, @Nullable DATATYPE DATATYPE) {
        return this.createChildItem(KEYTYPE, DATATYPE, true);
    }

    @Override
    @Nullable
    public final ITEMTYPE createChildItem(@Nullable KEYTYPE KEYTYPE, @Nullable DATATYPE DATATYPE, boolean bl) {
        if (!this.isValidDataID(KEYTYPE)) {
            throw new IllegalArgumentException("Illegal data ID provided");
        }
        ITEMTYPE ITEMTYPE = this.getChildItemOfDataID(KEYTYPE);
        if (ITEMTYPE != null) {
            if (!bl) {
                return null;
            }
            ITEMTYPE.setData(DATATYPE);
        } else {
            ITEMTYPE = this.m_aFactory.create(this._asT(this), KEYTYPE);
            if (ITEMTYPE == null) {
                throw new IllegalStateException("null item created!");
            }
            ITEMTYPE.setData(DATATYPE);
            if (this.m_aChildMap == null) {
                this.m_aChildMap = new HashMap<KEYTYPE, ITEMTYPE>();
                this.m_aChildren = new ArrayList<ITEMTYPE>();
            }
            this.m_aChildMap.put(KEYTYPE, ITEMTYPE);
            this.m_aChildren.add(ITEMTYPE);
        }
        return ITEMTYPE;
    }

    @Override
    public final boolean containsChildItemWithDataID(@Nullable KEYTYPE KEYTYPE) {
        return this.m_aChildMap != null && this.m_aChildMap.containsKey(KEYTYPE);
    }

    @Override
    @Nullable
    public final ITEMTYPE getChildItemOfDataID(@Nullable KEYTYPE KEYTYPE) {
        return (ITEMTYPE)(this.m_aChildMap == null ? null : (ITreeItemWithID)this.m_aChildMap.get(KEYTYPE));
    }

    @Override
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public final boolean isSameOrChildOf(@Nonnull ITEMTYPE ITEMTYPE) {
        ValueEnforcer.notNull(ITEMTYPE, "Parent");
        for (ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE> iTreeItemWithID = this; iTreeItemWithID != null; iTreeItemWithID = (ITreeItemWithID)iTreeItemWithID.getParent()) {
            if (iTreeItemWithID != ITEMTYPE) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public final ESuccess changeParent(@Nonnull ITEMTYPE ITEMTYPE) {
        ValueEnforcer.notNull(ITEMTYPE, "NewParent");
        if (this.getParent() == ITEMTYPE) {
            return ESuccess.SUCCESS;
        }
        ITEMTYPE ITEMTYPE2 = this._asT(this);
        if (ITEMTYPE.isSameOrChildOf(ITEMTYPE2)) {
            return ESuccess.FAILURE;
        }
        if (this.m_aParent.removeChild(this.getID()).isUnchanged()) {
            throw new IllegalStateException("Failed to remove this from parent!");
        }
        this.m_aParent = ITEMTYPE;
        return ESuccess.valueOfChange(ITEMTYPE.internalAddChild(this.getID(), ITEMTYPE2, false));
    }

    @Override
    @Nonnull
    public final EChange internalAddChild(@Nonnull KEYTYPE KEYTYPE, @Nonnull ITEMTYPE ITEMTYPE, boolean bl) {
        ValueEnforcer.notNull(ITEMTYPE, "Child");
        if (this.m_aChildMap != null) {
            if (!bl && this.m_aChildMap.containsKey(KEYTYPE)) {
                return EChange.UNCHANGED;
            }
        } else {
            this.m_aChildMap = new HashMap<KEYTYPE, ITEMTYPE>();
            this.m_aChildren = new ArrayList<ITEMTYPE>();
        }
        this.m_aChildMap.put(KEYTYPE, ITEMTYPE);
        this.m_aChildren.add(ITEMTYPE);
        this.m_aFactory.onAddItem(ITEMTYPE);
        return EChange.CHANGED;
    }

    private void _recursiveRemoveFromFactory(@Nonnull ITEMTYPE ITEMTYPE) {
        if (ITEMTYPE.hasChildren()) {
            for (ITreeItemWithID iTreeItemWithID : ITEMTYPE.getAllChildren()) {
                this._recursiveRemoveFromFactory(iTreeItemWithID);
            }
        }
        this.m_aFactory.onRemoveItem(ITEMTYPE);
    }

    @Override
    @Nonnull
    public final EChange removeChild(@Nullable KEYTYPE KEYTYPE) {
        if (KEYTYPE == null) {
            return EChange.UNCHANGED;
        }
        if (this.m_aChildMap == null) {
            return EChange.UNCHANGED;
        }
        ITreeItemWithID iTreeItemWithID = (ITreeItemWithID)this.m_aChildMap.remove(KEYTYPE);
        if (iTreeItemWithID == null) {
            return EChange.UNCHANGED;
        }
        if (!this.m_aChildren.remove(iTreeItemWithID)) {
            throw new IllegalStateException("Failed to remove item from list: " + iTreeItemWithID);
        }
        this._recursiveRemoveFromFactory(iTreeItemWithID);
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public final EChange removeAllChildren() {
        if (this.m_aChildMap == null || this.m_aChildMap.isEmpty()) {
            return EChange.UNCHANGED;
        }
        List<ITreeItemWithID> list = ContainerHelper.newList(this.m_aChildren);
        this.m_aChildMap.clear();
        this.m_aChildren.clear();
        for (ITreeItemWithID iTreeItemWithID : list) {
            this._recursiveRemoveFromFactory(iTreeItemWithID);
        }
        return EChange.CHANGED;
    }

    @Override
    public final void reorderChildrenByItems(@Nonnull Comparator<? super ITEMTYPE> comparator) {
        if (this.m_aChildren != null) {
            ContainerHelper.getSortedInline(this.m_aChildren, comparator);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BasicTreeItemWithID basicTreeItemWithID = (BasicTreeItemWithID)object;
        return EqualsUtils.equals(this.m_aDataID, basicTreeItemWithID.m_aDataID) && EqualsUtils.equals(this.m_aData, basicTreeItemWithID.m_aData) && EqualsUtils.equals(this.m_aChildMap, basicTreeItemWithID.m_aChildMap);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aData).append(this.m_aDataID).append((Map)this.m_aChildMap)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("dataID", this.m_aDataID).append("data", this.m_aData).append("children", this.m_aChildMap).toString();
    }
}

