/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.xpath;

import com.helger.commons.ICloneable;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.xpath.MapBasedXPathVariableResolverQName;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;

@NotThreadSafe
public class MapBasedXPathVariableResolver
implements XPathVariableResolver,
ICloneable<MapBasedXPathVariableResolver> {
    private final Map<String, Object> m_aMap;

    public MapBasedXPathVariableResolver() {
        this((Map)null);
    }

    public MapBasedXPathVariableResolver(@Nullable Map<String, ?> map) {
        this.m_aMap = ContainerHelper.newMap(map);
    }

    public MapBasedXPathVariableResolver(@Nonnull MapBasedXPathVariableResolver mapBasedXPathVariableResolver) {
        ValueEnforcer.notNull(mapBasedXPathVariableResolver, "Other");
        this.m_aMap = ContainerHelper.newMap(mapBasedXPathVariableResolver.m_aMap);
    }

    @Nonnull
    public EChange addUniqueVariable(@Nonnull String string, @Nonnull Object object) {
        ValueEnforcer.notNull(string, "Name");
        ValueEnforcer.notNull(object, "Value");
        if (this.m_aMap.containsKey(string)) {
            return EChange.UNCHANGED;
        }
        this.m_aMap.put(string, object);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange addAllFrom(@Nonnull MapBasedXPathVariableResolver mapBasedXPathVariableResolver, boolean bl) {
        ValueEnforcer.notNull(mapBasedXPathVariableResolver, "Other");
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry<String, Object> entry : mapBasedXPathVariableResolver.m_aMap.entrySet()) {
            if (!bl && this.m_aMap.containsKey(entry.getKey())) continue;
            this.m_aMap.put(entry.getKey(), entry.getValue());
            eChange = EChange.CHANGED;
        }
        return eChange;
    }

    @Nonnull
    public EChange addAllFrom(@Nonnull MapBasedXPathVariableResolverQName mapBasedXPathVariableResolverQName, boolean bl) {
        ValueEnforcer.notNull(mapBasedXPathVariableResolverQName, "Other");
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry<QName, ?> entry : mapBasedXPathVariableResolverQName.getAllVariables().entrySet()) {
            String string = entry.getKey().getLocalPart();
            if (!bl && this.m_aMap.containsKey(string)) continue;
            this.m_aMap.put(string, entry.getValue());
            eChange = EChange.CHANGED;
        }
        return eChange;
    }

    @Nonnull
    public EChange removeVariable(@Nullable String string) {
        return EChange.valueOf(this.m_aMap.remove(string) != null);
    }

    @Nonnull
    public EChange removeVariables(@Nullable Iterable<String> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (String string : iterable) {
                eChange = eChange.or(this.removeVariable(string));
            }
        }
        return eChange;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Map<String, ?> getAllVariables() {
        return ContainerHelper.newMap(this.m_aMap);
    }

    @Nonnegative
    public int getVariableCount() {
        return this.m_aMap.size();
    }

    @Nonnull
    public EChange clear() {
        if (this.m_aMap.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMap.clear();
        return EChange.CHANGED;
    }

    public void setAllVariables(@Nullable Map<String, ?> map) {
        this.m_aMap.clear();
        if (map != null) {
            this.m_aMap.putAll(map);
        }
    }

    @Override
    @Nullable
    public Object resolveVariable(@Nonnull QName qName) {
        ValueEnforcer.notNull(qName, "VariableName");
        String string = qName.getLocalPart();
        return this.m_aMap.get(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public MapBasedXPathVariableResolver getClone() {
        return new MapBasedXPathVariableResolver(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedXPathVariableResolver mapBasedXPathVariableResolver = (MapBasedXPathVariableResolver)object;
        return EqualsUtils.equals(this.m_aMap, mapBasedXPathVariableResolver.m_aMap);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aMap)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("map", this.m_aMap).toString();
    }
}

